/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.DefaultWorkingCopyInfo;
import org.eclipse.handly.model.impl.IBodyCache;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.IElementImplSupport;
import org.eclipse.handly.model.impl.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.WorkingCopyInfo;

public class ElementManager {
    private static final ISourceFile[] NO_WORKING_COPIES = new ISourceFile[0];
    protected final IBodyCache cache;
    private ThreadLocal<Map<IElement, Object>> temporaryCache = new ThreadLocal();
    private Map<ISourceFileImplSupport, WorkingCopyInfo> workingCopyInfos = new HashMap<ISourceFileImplSupport, WorkingCopyInfo>();

    public ElementManager(IBodyCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        this.cache = cache;
    }

    public final synchronized ISourceFile[] getWorkingCopies() {
        return this.workingCopyInfos.keySet().toArray(NO_WORKING_COPIES);
    }

    protected void close(IElement element, IContext context) {
        ((IElementImplExtension)element).hClose(context);
    }

    synchronized Object get(IElementImplSupport element) {
        Object body;
        Map<IElement, Object> tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(element)) != null) {
            return body;
        }
        return this.cache.get(element);
    }

    synchronized Object peek(IElementImplSupport element) {
        Object body;
        Map<IElement, Object> tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(element)) != null) {
            return body;
        }
        return this.cache.peek(element);
    }

    synchronized void put(IElementImplSupport element, Map<IElement, Object> newElements) {
        WorkingCopyInfo info;
        Object body = this.cache.peek(element);
        if (body != null) {
            IElement[] iElementArray = element.hChildren(body);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.close(child, Contexts.of(IElementImplExtension.CLOSE_HINT, IElementImplExtension.CloseHint.PARENT_CLOSING));
                ++n2;
            }
        }
        this.cache.putAll(newElements);
        if (element instanceof ISourceFileImplSupport && (info = this.workingCopyInfos.get(element)) != null && !info.created) {
            info.created = true;
        }
    }

    synchronized Object putIfAbsent(IElementImplSupport element, Map<IElement, Object> newElements) {
        Object existingBody = this.cache.peek(element);
        if (existingBody != null) {
            return existingBody;
        }
        this.cache.putAll(newElements);
        return null;
    }

    synchronized void remove(IElementImplSupport element) {
        Object body = this.cache.peek(element);
        if (body != null) {
            element.hRemoving(body);
            IElement[] iElementArray = element.hChildren(body);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.close(child, Contexts.of(IElementImplExtension.CLOSE_HINT, IElementImplExtension.CloseHint.PARENT_CLOSING));
                ++n2;
            }
            this.cache.remove(element);
        }
    }

    Map<IElement, Object> getTemporaryCache() {
        Map<IElement, Object> result = this.temporaryCache.get();
        if (result == null) {
            result = new HashMap<IElement, Object>();
            this.temporaryCache.set(result);
        }
        return result;
    }

    boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    WorkingCopyInfo putWorkingCopyInfoIfAbsent(ISourceFileImplSupport sourceFile, IBuffer buffer, WorkingCopyInfo.Factory factory) {
        WorkingCopyInfo workingCopyInfo;
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        WorkingCopyInfo info = factory == null ? new DefaultWorkingCopyInfo(sourceFile, buffer) : factory.newWorkingCopyInfo(sourceFile, buffer);
        if (info.refCount != 0) {
            throw new AssertionError();
        }
        if (info.getSourceFile() != sourceFile) {
            throw new AssertionError();
        }
        boolean disposeInfo = true;
        boolean releaseBuffer = false;
        if (info.getBuffer() != buffer) {
            throw new AssertionError();
        }
        buffer.addRef();
        releaseBuffer = true;
        ElementManager elementManager = this;
        synchronized (elementManager) {
            WorkingCopyInfo oldInfo = this.workingCopyInfos.get(sourceFile);
            if (oldInfo != null) {
                ++oldInfo.refCount;
            } else {
                this.workingCopyInfos.put(sourceFile, info);
                info.refCount = 1;
                disposeInfo = false;
                releaseBuffer = false;
            }
            workingCopyInfo = oldInfo;
        }
        try {
            if (disposeInfo) {
                info.dispose();
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
        return workingCopyInfo;
        {
            catch (Throwable throwable) {
                try {
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    try {
                        if (disposeInfo) {
                            info.dispose();
                        }
                    }
                    finally {
                        if (releaseBuffer) {
                            buffer.release();
                        }
                    }
                    throw throwable2;
                }
            }
        }
    }

    synchronized WorkingCopyInfo getWorkingCopyInfo(ISourceFileImplSupport sourceFile) {
        WorkingCopyInfo info = this.workingCopyInfos.get(sourceFile);
        if (info != null) {
            ++info.refCount;
        }
        return info;
    }

    synchronized WorkingCopyInfo peekAtWorkingCopyInfo(ISourceFileImplSupport sourceFile) {
        return this.workingCopyInfos.get(sourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkingCopyInfo releaseWorkingCopyInfo(ISourceFileImplSupport sourceFile) {
        WorkingCopyInfo infoToDispose = null;
        try {
            ElementManager elementManager = this;
            synchronized (elementManager) {
                WorkingCopyInfo info = this.workingCopyInfos.get(sourceFile);
                if (info != null && --info.refCount == 0) {
                    infoToDispose = info;
                    this.workingCopyInfos.remove(sourceFile);
                    sourceFile.hRemove(Contexts.EMPTY_CONTEXT);
                }
                WorkingCopyInfo workingCopyInfo = info;
                return workingCopyInfo;
            }
        }
        finally {
            if (infoToDispose != null) {
                IBuffer buffer = infoToDispose.getBuffer();
                try {
                    infoToDispose.dispose();
                }
                finally {
                    buffer.release();
                }
            }
        }
    }
}

