/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.impl.Body;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.IModelManager;
import org.eclipse.handly.model.impl.Messages;
import org.eclipse.handly.util.IndentPolicy;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.ToStringOptions;

public interface IElementImplSupport
extends IElementImplExtension,
IModelManager.Provider {
    public static final Property<Map<IElement, Object>> NEW_ELEMENTS = new Property<Map<IElement, Object>>(String.valueOf(IElementImplSupport.class.getName()) + ".newElements"){};
    public static final Object NO_BODY = new Object();

    default public int hDefaultHashCode() {
        int prime = 31;
        int result = 1;
        IElement parent = this.hParent();
        String name = this.hName();
        result = 31 * result + (parent == null ? 0 : parent.hashCode());
        result = 31 * result + (name == null ? 0 : name.hashCode());
        return result;
    }

    default public boolean hDefaultEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IElementImplSupport)) {
            return false;
        }
        IElementImplSupport other = (IElementImplSupport)obj;
        if (!other.hCanEqual(this)) {
            return false;
        }
        IElement parent = this.hParent();
        if (parent == null ? other.hParent() != null : !parent.equals(other.hParent())) {
            return false;
        }
        String name = this.hName();
        return !(name == null ? other.hName() != null : !name.equals(other.hName()));
    }

    default public boolean hCanEqual(Object obj) {
        return this.getClass() == obj.getClass();
    }

    @Override
    default public IModel hModel() {
        return this.hModelManager().getModel();
    }

    default public ElementManager hElementManager() {
        return this.hModelManager().getElementManager();
    }

    @Override
    default public IElement[] hChildren(Object body) {
        return ((Body)body).getChildren();
    }

    @Override
    default public Object hFindBody() {
        return this.hElementManager().get(this);
    }

    @Override
    default public Object hPeekAtBody() {
        return this.hElementManager().peek(this);
    }

    @Override
    default public boolean hExists() {
        if (this.hFindBody() != null) {
            return true;
        }
        IElement parent = this.hParent();
        if (parent != null && !Elements.exists(parent)) {
            return false;
        }
        try {
            this.hValidateExistence(Contexts.EMPTY_CONTEXT);
            return true;
        }
        catch (CoreException e) {
            return false;
        }
    }

    public void hValidateExistence(IContext var1) throws CoreException;

    default public CoreException hDoesNotExistException() {
        return new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.Element_Does_not_exist__0, this.hToDisplayString(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.FULL))), null));
    }

    @Override
    default public Object hOpen(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ElementManager elementManager = this.hElementManager();
        boolean hadTemporaryCache = elementManager.hasTemporaryCache();
        try {
            Map<IElement, Object> newElements = elementManager.getTemporaryCache();
            this.hGenerateBodies(Contexts.with(Contexts.of(NEW_ELEMENTS, newElements), context), monitor);
            Object body = newElements.get(this);
            if (body == null) {
                IElementImplSupport openable = this.hOpenableParent();
                Object openableBody = newElements.get(openable);
                if (openableBody != null) {
                    openable.hRemoving(openableBody);
                }
                throw this.hDoesNotExistException();
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!hadTemporaryCache) {
                if (((Boolean)context.getOrDefault(FORCE_OPEN)).booleanValue()) {
                    elementManager.put(this, newElements);
                } else {
                    Object existingBody = elementManager.putIfAbsent(this, newElements);
                    if (existingBody != null) {
                        body = existingBody;
                    }
                }
            }
            Object object = body;
            return object;
        }
        finally {
            if (!hadTemporaryCache) {
                elementManager.resetTemporaryCache();
            }
        }
    }

    default public void hGenerateBodies(IContext context, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        try {
            this.hGenerateAncestorBodies(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.hIsOpenable()) {
                this.hValidateExistence(context);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.hBuildStructure(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                Object body = context.get(NEW_ELEMENTS).get(this);
                if (body == null) {
                    throw new AssertionError((Object)MessageFormat.format("No body for {0}. Incorrect {1}#hBuildStructure implementation?", this.toString(), this.getClass().getSimpleName()));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    default public void hGenerateAncestorBodies(IContext context, IProgressMonitor monitor) throws CoreException {
        IElementImplSupport openableParent = this.hOpenableParent();
        if (openableParent != null && openableParent.hFindBody() == null) {
            openableParent.hGenerateBodies(context, monitor);
        }
    }

    default public boolean hIsOpenable() {
        return true;
    }

    default public IElementImplSupport hOpenableParent() {
        IElement parent = this.hParent();
        while (parent != null) {
            IElementImplSupport p;
            if (parent instanceof IElementImplSupport && (p = (IElementImplSupport)parent).hIsOpenable()) {
                return p;
            }
            parent = Elements.getParent(parent);
        }
        return null;
    }

    public void hBuildStructure(IContext var1, IProgressMonitor var2) throws CoreException;

    @Override
    default public void hClose(IContext context) {
        IElementImplExtension.CloseHint hint = (IElementImplExtension.CloseHint)((Object)context.get(CLOSE_HINT));
        if (hint != IElementImplExtension.CloseHint.PARENT_CLOSING && !this.hIsOpenable()) {
            return;
        }
        this.hRemove(context);
    }

    default public void hRemove(IContext context) {
        this.hElementManager().remove(this);
    }

    default public void hRemoving(Object body) {
    }

    @Override
    default public String hToString(IContext context) {
        StringBuilder builder = new StringBuilder();
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        ToStringOptions.FormatStyle style = context.getOrDefault(ToStringOptions.FORMAT_STYLE);
        if (style == ToStringOptions.FormatStyle.FULL || style == ToStringOptions.FormatStyle.LONG) {
            Object body = this.hPeekAtBody();
            indentPolicy.appendIndent(builder, indentLevel);
            this.hToStringBody(builder, body, context);
            if (style == ToStringOptions.FormatStyle.FULL) {
                this.hToStringAncestors(builder, context);
            }
            if (body != null && this.hChildren(body).length > 0) {
                indentPolicy.appendLine(builder);
                this.hToStringChildren(builder, body, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.LONG), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
        } else {
            indentPolicy.appendIndent(builder, indentLevel);
            this.hToStringBody(builder, NO_BODY, context);
            if (style == ToStringOptions.FormatStyle.MEDIUM) {
                this.hToStringAncestors(builder, context);
            }
        }
        return builder.toString();
    }

    default public void hToStringAncestors(StringBuilder builder, IContext context) {
        IElement parent = this.hParent();
        if (parent != null && Elements.getParent(parent) != null) {
            builder.append(" [in ");
            builder.append(Elements.toString(parent, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
            builder.append(']');
        }
    }

    default public void hToStringChildren(StringBuilder builder, Object body, IContext context) {
        if (body == null) {
            return;
        }
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        IElement[] children = this.hChildren(body);
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            builder.append(Elements.toString(children[i], context));
            ++i;
        }
    }

    default public void hToStringBody(StringBuilder builder, Object body, IContext context) {
        this.hToStringName(builder, context);
        if (body == null) {
            builder.append(" (not open)");
        }
    }

    default public void hToStringName(StringBuilder builder, IContext context) {
        builder.append(this.hName());
    }
}

