/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.IElementImplSupport;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.TextRange;

public interface ISourceElementImplSupport
extends IElementImplSupport,
ISourceElementImpl {
    @Override
    default public ISourceElementInfo hSourceElementInfo() throws CoreException {
        return (ISourceElementInfo)this.hBody();
    }

    @Override
    default public ISourceElement hSourceElementAt(int position, ISnapshot base) throws CoreException {
        ISourceElementInfo info = this.hSourceElementInfo();
        if (!ISourceElementImplSupport.checkInRange(position, base, info)) {
            return null;
        }
        return this.hSourceElementAt(position, info);
    }

    default public ISourceElement hSourceElementAt(int position, ISourceElementInfo info) throws CoreException {
        ISourceConstruct[] children;
        ISnapshot snapshot = info.getSnapshot();
        ISourceConstruct[] iSourceConstructArray = children = info.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceConstruct child = iSourceConstructArray[n2];
            ISourceElement found = Elements.getSourceElementAt(child, position, snapshot);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return this;
    }

    public static boolean checkInRange(int position, ISnapshot base, ISourceElementInfo info) {
        ISnapshot snapshot = info.getSnapshot();
        if (snapshot == null) {
            return false;
        }
        if (base != null && !base.isEqualTo(snapshot)) {
            throw new StaleSnapshotException();
        }
        TextRange textRange = info.getFullRange();
        return textRange != null && textRange.covers(position);
    }
}

