/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.ElementChangeEvent;
import org.eclipse.handly.model.impl.ElementDelta;
import org.eclipse.handly.model.impl.ElementDifferencer;
import org.eclipse.handly.model.impl.ElementManager;
import org.eclipse.handly.model.impl.INotificationManager;
import org.eclipse.handly.model.impl.ISourceElementImplSupport;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.handly.model.impl.SourceElementBody;
import org.eclipse.handly.model.impl.WorkingCopyInfo;
import org.eclipse.handly.model.impl.WorkingCopyProvider;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.ISnapshotProvider;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.handly.util.ToStringOptions;

public interface ISourceFileImplSupport
extends ISourceElementImplSupport,
ISourceFileImpl {
    public static final Property<IBuffer> WORKING_COPY_BUFFER = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".workingCopyBuffer", IBuffer.class);
    public static final Property<WorkingCopyInfo.Factory> WORKING_COPY_INFO_FACTORY = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".workingCopyInfoFactory", WorkingCopyInfo.Factory.class);
    public static final Property<Object> SOURCE_AST = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".sourceAst", Object.class);
    public static final Property<String> SOURCE_CONTENTS = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".sourceContents", String.class);
    public static final Property<ISnapshot> SOURCE_SNAPSHOT = Property.get(String.valueOf(ISourceFileImplSupport.class.getName()) + ".sourceSnapshot", ISnapshot.class);

    @Override
    default public int hDefaultHashCode() {
        IFile file = this.hFile();
        if (file != null) {
            return file.hashCode();
        }
        return ISourceElementImplSupport.super.hDefaultHashCode();
    }

    @Override
    default public boolean hDefaultEquals(Object obj) {
        if (!(obj instanceof ISourceFileImplSupport)) {
            return false;
        }
        IFile file = this.hFile();
        return ISourceElementImplSupport.super.hDefaultEquals(obj) && (file == null || file.equals((Object)((ISourceFileImplSupport)obj).hFile()));
    }

    @Override
    default public IBuffer hBuffer(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            IBuffer iBuffer;
            WorkingCopyInfo info = this.hAcquireExistingWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (info == null) {
                IBuffer iBuffer2 = this.hFileBuffer(context, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                return iBuffer2;
            }
            try {
                IBuffer buffer = info.getBuffer();
                buffer.addRef();
                iBuffer = buffer;
                this.hReleaseWorkingCopy();
            }
            catch (Throwable throwable) {
                this.hReleaseWorkingCopy();
                throw throwable;
            }
            return iBuffer;
        }
        finally {
            monitor.done();
        }
    }

    default public WorkingCopyInfo hBecomeWorkingCopy(final IContext context, final IProgressMonitor monitor) throws CoreException {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        final IBuffer buffer = context.get(WORKING_COPY_BUFFER);
        if (buffer == null) {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IBuffer defaultBuffer = this.hFileBuffer(context, monitor);){
                return this.hBecomeWorkingCopy(Contexts.with(Contexts.of(WORKING_COPY_BUFFER, defaultBuffer), context), monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        WorkingCopyProvider provider = new WorkingCopyProvider(this){

            @Override
            protected WorkingCopyInfo doAcquireWorkingCopy() {
                return ISourceFileImplSupport.this.hElementManager().putWorkingCopyInfoIfAbsent(ISourceFileImplSupport.this, buffer, context.get(WORKING_COPY_INFO_FACTORY));
            }

            @Override
            protected boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        WorkingCopyInfo oldInfo = provider.acquireWorkingCopy();
        if (oldInfo == null) {
            boolean success = false;
            try {
                WorkingCopyInfo newInfo = this.hElementManager().peekAtWorkingCopyInfo(this);
                newInfo.initTask.execute(context, monitor);
                success = true;
            }
            finally {
                if (!success) {
                    this.hReleaseWorkingCopy();
                }
            }
        }
        return oldInfo;
    }

    default public WorkingCopyInfo hAcquireExistingWorkingCopy(final IProgressMonitor monitor) {
        WorkingCopyProvider provider = new WorkingCopyProvider(this){

            @Override
            protected WorkingCopyInfo doAcquireWorkingCopy() {
                return ISourceFileImplSupport.this.hElementManager().getWorkingCopyInfo(ISourceFileImplSupport.this);
            }

            @Override
            protected boolean isCanceled() {
                if (monitor == null) {
                    return false;
                }
                return monitor.isCanceled();
            }
        };
        return provider.acquireWorkingCopy();
    }

    default public boolean hReleaseWorkingCopy() {
        WorkingCopyInfo info = this.hElementManager().releaseWorkingCopyInfo(this);
        if (info == null) {
            throw new IllegalStateException("Not a working copy: " + this.hToString(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM)));
        }
        if (info.isDisposed() && info.created) {
            this.hWorkingCopyModeChanged();
            return true;
        }
        return false;
    }

    default public WorkingCopyInfo hWorkingCopyInfo() {
        WorkingCopyInfo info = this.hElementManager().peekAtWorkingCopyInfo(this);
        if (info == null) {
            return null;
        }
        if (info.created) {
            return info;
        }
        if (this.equals(ReconcileOperation.CURRENTLY_RECONCILED.get())) {
            return info;
        }
        return null;
    }

    @Override
    default public boolean hIsWorkingCopy() {
        return this.hWorkingCopyInfo() != null;
    }

    @Override
    default public boolean hNeedsReconciling() {
        WorkingCopyInfo info = this.hAcquireExistingWorkingCopy(null);
        if (info == null) {
            return false;
        }
        try {
            boolean bl = info.needsReconciling();
            return bl;
        }
        finally {
            this.hReleaseWorkingCopy();
        }
    }

    @Override
    default public void hReconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 100);
        try {
            WorkingCopyInfo info = this.hAcquireExistingWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (info == null) {
                return;
            }
            try {
                info.reconcile(context, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
            }
            finally {
                this.hReleaseWorkingCopy();
            }
        }
        finally {
            monitor.done();
        }
    }

    default public ReconcileOperation hReconcileOperation() {
        if (this.hModel().getModelContext().get(INotificationManager.class) != null) {
            return new NotifyingReconcileOperation(this);
        }
        return new ReconcileOperation(this);
    }

    default public IContext hWorkingCopyContext(IContext context) {
        return Contexts.EMPTY_CONTEXT;
    }

    default public void hWorkingCopyModeChanged() {
        INotificationManager notificationManager = this.hModel().getModelContext().get(INotificationManager.class);
        if (notificationManager == null) {
            return;
        }
        ElementDelta.Factory deltaFactory = this.hModel().getModelContext().get(ElementDelta.Factory.class);
        if (deltaFactory == null) {
            deltaFactory = element -> new ElementDelta(element);
        }
        ElementDelta rootDelta = deltaFactory.newDelta(this.hRoot());
        ElementDelta.Builder builder = new ElementDelta.Builder(rootDelta);
        if (this.hFileExists()) {
            builder.changed(this, 256L);
        } else if (this.hIsWorkingCopy()) {
            builder.added(this, 256L);
        } else {
            builder.removed(this, 256L);
        }
        notificationManager.fireElementChangeEvent(new ElementChangeEvent(1, builder.getDelta()));
    }

    default public boolean hFileExists() {
        IFile file = this.hFile();
        if (file == null) {
            throw new AssertionError((Object)"Please override this method");
        }
        return file.exists();
    }

    default public ISnapshotProvider hFileSnapshotProvider() {
        IFile file = this.hFile();
        if (file == null) {
            throw new AssertionError((Object)"Please override this method");
        }
        return () -> {
            TextFileSnapshot result = new TextFileSnapshot(file, TextFileSnapshot.Layer.FILESYSTEM);
            if (!result.exists()) {
                throw new IllegalStateException(this.hDoesNotExistException());
            }
            if (result.getContents() == null && !result.getStatus().isOK()) {
                throw new IllegalStateException(new CoreException(result.getStatus()));
            }
            return result;
        };
    }

    default public IBuffer hFileBuffer(IContext context, IProgressMonitor monitor) throws CoreException {
        IFile file = this.hFile();
        if (file == null) {
            throw new AssertionError((Object)"Please override this method");
        }
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forLocation(file.getFullPath(), LocationKind.IFILE, ITextFileBufferManager.DEFAULT);
        if (!context.getOrDefault(Elements.CREATE_BUFFER).booleanValue() && provider.getBuffer() == null) {
            return null;
        }
        return new TextFileBuffer(provider, monitor);
    }

    @Override
    default public void hValidateExistence(IContext context) throws CoreException {
        if (!this.hIsWorkingCopy() && !this.hFileExists()) {
            throw this.hDoesNotExistException();
        }
    }

    @Override
    default public void hGenerateAncestorBodies(IContext context, IProgressMonitor monitor) throws CoreException {
        if (this.hIsWorkingCopy()) {
            return;
        }
        ISourceElementImplSupport.super.hGenerateAncestorBodies(context, monitor);
    }

    @Override
    default public void hBuildStructure(IContext context, IProgressMonitor monitor) throws CoreException {
        if (!context.containsKey(SOURCE_CONTENTS) && !context.containsKey(SOURCE_AST)) {
            NonExpiringSnapshot snapshot;
            if (this.hIsWorkingCopy()) {
                throw new AssertionError();
            }
            Throwable throwable = null;
            Object var5_5 = null;
            try (ISnapshotProvider provider = this.hFileSnapshotProvider();){
                try {
                    snapshot = new NonExpiringSnapshot(provider);
                }
                catch (IllegalStateException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CoreException) {
                        throw (CoreException)cause;
                    }
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            context = Contexts.with(Contexts.of(SOURCE_CONTENTS, snapshot.getContents()), Contexts.of(SOURCE_SNAPSHOT, snapshot.getWrappedSnapshot()), context);
        }
        this.hBuildSourceStructure(context, monitor);
        Map newElements = (Map)context.get(NEW_ELEMENTS);
        Object body = newElements.get(this);
        if (body instanceof SourceElementBody) {
            ISnapshot snapshot;
            SourceElementBody thisBody = (SourceElementBody)body;
            String source = context.get(SOURCE_CONTENTS);
            if (source != null) {
                thisBody.setFullRange(new TextRange(0, source.length()));
            }
            if ((snapshot = context.get(SOURCE_SNAPSHOT)) != null) {
                thisBody.setSnapshot(snapshot, newElements);
            }
        }
    }

    public void hBuildSourceStructure(IContext var1, IProgressMonitor var2) throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public void hClose(IContext context) {
        ElementManager elementManager = this.hElementManager();
        synchronized (elementManager) {
            if (this.hIsWorkingCopy()) {
                return;
            }
            ISourceElementImplSupport.super.hClose(context);
        }
    }

    @Override
    default public void hToStringName(StringBuilder builder, IContext context) {
        if (this.hIsWorkingCopy()) {
            builder.append("[Working copy] ");
        }
        ISourceElementImplSupport.super.hToStringName(builder, context);
    }

    public static class NotifyingReconcileOperation
    extends ReconcileOperation {
        protected NotifyingReconcileOperation(ISourceFileImplSupport sourceFile) {
            super(sourceFile);
        }

        @Override
        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            ElementDifferencer differ = this.createDifferencer();
            this.doReconcile(context, monitor);
            differ.buildDelta();
            if (!differ.isEmptyDelta()) {
                this.sourceFile.hModel().getModelContext().get(INotificationManager.class).fireElementChangeEvent(new ElementChangeEvent(2, differ.getDelta()));
            }
        }

        protected ElementDifferencer createDifferencer() {
            ElementDelta.Factory deltaFactory = this.sourceFile.hModel().getModelContext().get(ElementDelta.Factory.class);
            if (deltaFactory == null) {
                deltaFactory = element -> new ElementDelta(element);
            }
            ElementDelta rootDelta = deltaFactory.newDelta(this.sourceFile);
            return new ElementDifferencer(new ElementDelta.Builder(rootDelta));
        }

        protected void doReconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            super.reconcile(context, monitor);
        }
    }

    public static class ReconcileOperation {
        protected static final Property<Boolean> REBUILD_STRUCTURE_IF_FORCED = Property.get(String.valueOf(ReconcileOperation.class.getName()) + ".rebuildStructureIfForced", Boolean.class).withDefault(false);
        static final Property<Boolean> RECONCILING_FORCED = Property.get(String.valueOf(ReconcileOperation.class.getName()) + ".reconcilingForced", Boolean.class).withDefault(false);
        static final ThreadLocal<ISourceFileImplSupport> CURRENTLY_RECONCILED = new ThreadLocal();
        protected final ISourceFileImplSupport sourceFile;

        protected ReconcileOperation(ISourceFileImplSupport sourceFile) {
            if (sourceFile == null) {
                throw new IllegalArgumentException();
            }
            this.sourceFile = sourceFile;
        }

        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            boolean create;
            if (context.get(SOURCE_AST) == null && context.get(SOURCE_CONTENTS) == null) {
                throw new IllegalArgumentException();
            }
            WorkingCopyInfo info = this.sourceFile.hElementManager().peekAtWorkingCopyInfo(this.sourceFile);
            boolean bl = create = !info.created;
            if (create || !context.getOrDefault(RECONCILING_FORCED).booleanValue() || context.getOrDefault(REBUILD_STRUCTURE_IF_FORCED).booleanValue()) {
                if (CURRENTLY_RECONCILED.get() != null) {
                    throw new AssertionError();
                }
                CURRENTLY_RECONCILED.set(this.sourceFile);
                try {
                    this.sourceFile.hOpen(Contexts.with(Contexts.of(FORCE_OPEN, Boolean.valueOf(true)), context), monitor);
                }
                finally {
                    CURRENTLY_RECONCILED.set(null);
                }
            }
            if (create) {
                if (!info.created) {
                    throw new AssertionError();
                }
                this.sourceFile.hWorkingCopyModeChanged();
            }
        }
    }
}

