/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.handly.model.impl.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.WorkingCopyInfo;

abstract class WorkingCopyProvider {
    private final ISourceFileImplSupport sourceFile;

    public WorkingCopyProvider(ISourceFileImplSupport sourceFile) {
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        this.sourceFile = sourceFile;
    }

    public WorkingCopyInfo acquireWorkingCopy() {
        WorkingCopyInfo info;
        boolean success;
        do {
            if (this.isCanceled()) {
                throw new OperationCanceledException();
            }
            info = this.doAcquireWorkingCopy();
            if (info == null) {
                return null;
            }
            success = false;
            try {
                success = this.waitForInit(info);
            }
            finally {
                if (!success) {
                    this.sourceFile.hReleaseWorkingCopy();
                }
            }
        } while (!success);
        return info;
    }

    protected abstract WorkingCopyInfo doAcquireWorkingCopy();

    protected boolean isCanceled() {
        return false;
    }

    private boolean waitForInit(WorkingCopyInfo info) {
        int i = 0;
        while (i < 10) {
            if (this.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                return info.initTask.wasSuccessful(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            ++i;
        }
        return false;
    }
}

