/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class LruCache<K, V>
implements Cloneable {
    protected int currentSpace = 0;
    protected int spaceLimit;
    protected int timestampCounter = 0;
    protected HashMap<K, LruCacheEntry<K, V>> entryTable;
    protected LruCacheEntry<K, V> entryQueue = null;
    protected LruCacheEntry<K, V> entryQueueTail = null;

    public LruCache(int spaceLimit) {
        this.entryTable = new HashMap(spaceLimit);
        this.spaceLimit = spaceLimit;
    }

    public Object clone() {
        LruCache newCache = this.newInstance(this.spaceLimit);
        LruCacheEntry<K, V> entry = this.entryQueueTail;
        while (entry != null) {
            newCache.privateAdd(entry.key, entry.value, entry.space);
            entry = entry.previous;
        }
        return newCache;
    }

    public V get(Object key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        this.updateTimestamp(entry);
        return entry.value;
    }

    public V peek(Object key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    public K getKey(K key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return key;
        }
        return entry.key;
    }

    public Enumeration<K> keys() {
        return new Enumeration<K>(){
            Iterator<K> keys;
            {
                this.keys = LruCache.this.entryTable.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.keys.hasNext();
            }

            @Override
            public K nextElement() {
                return this.keys.next();
            }
        };
    }

    public ICacheEnumeration<K, V> keysAndValues() {
        return new ICacheEnumeration<K, V>(){
            Iterator<LruCacheEntry<K, V>> entries;
            LruCacheEntry<K, V> current;
            {
                this.entries = LruCache.this.entryTable.values().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.entries.hasNext();
            }

            @Override
            public K nextElement() {
                this.current = this.entries.next();
                return this.current.key;
            }

            @Override
            public V getValue() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                return this.current.value;
            }
        };
    }

    public Enumeration<V> elements() {
        if (this.entryQueue == null) {
            return new LruCacheEnumerator(null);
        }
        LruEnumeratorElement head = new LruEnumeratorElement(this.entryQueue.value);
        LruCacheEntry currentEntry = this.entryQueue.next;
        LruEnumeratorElement currentElement = head;
        while (currentEntry != null) {
            currentElement.next = new LruEnumeratorElement(currentEntry.value);
            currentElement = currentElement.next;
            currentEntry = currentEntry.next;
        }
        return new LruCacheEnumerator(head);
    }

    public V put(K key, V value) {
        V oldValue = null;
        int newSpace = this.spaceFor(value);
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry != null) {
            oldValue = entry.value;
            int oldSpace = entry.space;
            int newTotal = this.currentSpace - oldSpace + newSpace;
            if (newTotal <= this.spaceLimit) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                return oldValue;
            }
            this.privateRemoveEntry(entry, false);
        }
        if (this.makeSpace(newSpace)) {
            this.privateAdd(key, value, newSpace);
        }
        return oldValue;
    }

    public V remove(Object key) {
        LruCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.value;
        this.privateRemoveEntry(entry, false);
        return value;
    }

    public void clear() {
        this.currentSpace = 0;
        this.entryTable = new HashMap();
        this.entryQueueTail = null;
        this.entryQueue = null;
    }

    public double fillingRatio() {
        return (double)this.currentSpace * 100.0 / (double)this.spaceLimit;
    }

    public final int getCurrentSpace() {
        return this.currentSpace;
    }

    public int getNewestTimestamp() {
        return this.entryQueue == null ? 0 : this.entryQueue.timestamp;
    }

    public int getOldestTimestamp() {
        return this.entryQueueTail == null ? 0 : this.entryQueueTail.timestamp;
    }

    public K getNewestKey() {
        return this.entryQueue == null ? null : (K)this.entryQueue.key;
    }

    public K getOldestKey() {
        return this.entryQueueTail == null ? null : (K)this.entryQueueTail.key;
    }

    public final int getSpaceLimit() {
        return this.spaceLimit;
    }

    public void setSpaceLimit(int limit) {
        if (limit < this.spaceLimit) {
            this.makeSpace(this.spaceLimit - limit);
        }
        this.spaceLimit = limit;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRatio("LruCache")) + '\n' + this.toStringContents();
    }

    public String toStringFillingRatio(String cacheName) {
        StringBuilder builder = new StringBuilder(cacheName);
        builder.append('[');
        builder.append(this.currentSpace);
        builder.append('/');
        builder.append(this.spaceLimit);
        builder.append("]: ");
        builder.append(NumberFormat.getInstance().format(this.fillingRatio()));
        builder.append("% full\n");
        return builder.toString();
    }

    protected String toStringContents() {
        StringBuilder result = new StringBuilder();
        LruCacheEntry<K, V> entry = this.entryQueue;
        while (entry != null) {
            result.append(entry.key);
            result.append(" -> ");
            result.append(entry.value);
            result.append('\n');
            entry = entry.next;
        }
        return result.toString();
    }

    protected LruCache<K, V> newInstance(int spaceLimit) {
        return new LruCache<K, V>(spaceLimit);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int space) {
        limit = this.getSpaceLimit();
        if (this.currentSpace + space <= limit) {
            return true;
        }
        if (space <= limit) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.entryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.currentSpace + space > limit && this.entryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected void privateAdd(K key, V value, int space) {
        LruCacheEntry<K, V> entry = new LruCacheEntry<K, V>(key, value, space);
        this.privateAddEntry(entry, false);
    }

    protected void privateAddEntry(LruCacheEntry<K, V> entry, boolean shuffle) {
        if (!shuffle) {
            this.entryTable.put(entry.key, entry);
            this.currentSpace += entry.space;
        }
        entry.timestamp = this.timestampCounter++;
        entry.next = this.entryQueue;
        entry.previous = null;
        if (this.entryQueue == null) {
            this.entryQueueTail = entry;
        } else {
            this.entryQueue.previous = entry;
        }
        this.entryQueue = entry;
    }

    protected void privateRemoveEntry(LruCacheEntry<K, V> entry, boolean shuffle) {
        LruCacheEntry previous = entry.previous;
        LruCacheEntry next = entry.next;
        if (!shuffle) {
            this.entryTable.remove(entry.key);
            this.currentSpace -= entry.space;
        }
        if (previous == null) {
            this.entryQueue = next;
        } else {
            previous.next = next;
        }
        if (next == null) {
            this.entryQueueTail = previous;
        } else {
            next.previous = previous;
        }
    }

    protected void updateTimestamp(LruCacheEntry<K, V> entry) {
        entry.timestamp = this.timestampCounter++;
        if (this.entryQueue != entry) {
            this.privateRemoveEntry(entry, true);
            this.privateAddEntry(entry, true);
        }
    }

    protected int spaceFor(V value) {
        return 1;
    }

    public static interface ICacheEnumeration<K, V>
    extends Enumeration<K> {
        public V getValue();
    }

    protected static class LruCacheEntry<K, V> {
        public final K key;
        public V value;
        public int timestamp;
        public int space;
        public LruCacheEntry<K, V> previous;
        public LruCacheEntry<K, V> next;

        public LruCacheEntry(K key, V value, int space) {
            this.key = key;
            this.value = value;
            this.space = space;
        }

        public String toString() {
            return "LruCacheEntry [" + this.key + " -> " + this.value + ']';
        }
    }

    static class LruCacheEnumerator<V>
    implements Enumeration<V> {
        LruEnumeratorElement<V> next;

        LruCacheEnumerator(LruEnumeratorElement<V> head) {
            this.next = head;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public V nextElement() {
            LruEnumeratorElement<V> current = this.next;
            this.next = current.next;
            return current.value;
        }
    }

    static class LruEnumeratorElement<V> {
        final V value;
        LruEnumeratorElement<V> next;

        LruEnumeratorElement(V value) {
            this.value = value;
        }
    }
}

