/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import org.eclipse.handly.util.LruCache;

public class OverflowingLruCache<K, V>
extends LruCache<K, V> {
    protected int overflow = 0;
    protected boolean timestampsOn = true;
    protected double loadFactor = 0.333;

    public OverflowingLruCache(int spaceLimit) {
        this(spaceLimit, 0);
    }

    protected OverflowingLruCache(int spaceLimit, int overflow) {
        super(spaceLimit);
        this.overflow = overflow;
    }

    @Override
    public Object clone() {
        OverflowingLruCache newCache = this.newInstance(this.spaceLimit, this.overflow);
        LruCache.LruCacheEntry qEntry = this.entryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry.key, qEntry.value, qEntry.space);
            qEntry = qEntry.previous;
        }
        return newCache;
    }

    @Override
    public V put(K key, V value) {
        if (this.overflow > 0) {
            this.shrink();
        }
        V oldValue = null;
        int newSpace = this.spaceFor(value);
        LruCache.LruCacheEntry entry = (LruCache.LruCacheEntry)this.entryTable.get(key);
        if (entry != null) {
            oldValue = entry.value;
            int oldSpace = entry.space;
            int newTotal = this.currentSpace - oldSpace + newSpace;
            if (newTotal <= this.spaceLimit) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                this.overflow = 0;
                return oldValue;
            }
            this.privateRemoveEntry(entry, false, false);
        }
        this.makeSpace(newSpace);
        this.privateAdd(key, value, newSpace);
        return oldValue;
    }

    public boolean shrink() {
        if (this.overflow > 0) {
            return this.makeSpace(0);
        }
        return true;
    }

    public final int getOverflow() {
        return this.overflow;
    }

    public final double getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(double loadFactor) {
        if (loadFactor <= 0.0 || loadFactor > 1.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
    }

    @Override
    public String toString() {
        return String.valueOf(this.toStringFillingRatio("OverflowingLruCache")) + '\n' + this.toStringContents();
    }

    protected boolean close(LruCache.LruCacheEntry<K, V> entry) {
        return true;
    }

    protected OverflowingLruCache<K, V> newInstance(int spaceLimit, int overflow) {
        return new OverflowingLruCache<K, V>(spaceLimit, overflow);
    }

    @Override
    protected LruCache<K, V> newInstance(int spaceLimit) {
        return this.newInstance(spaceLimit, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean makeSpace(int space) {
        if (this.overflow == 0 && this.currentSpace + space <= this.spaceLimit) {
            return true;
        }
        int spaceNeeded = (int)((1.0 - this.loadFactor) * (double)this.spaceLimit);
        spaceNeeded = spaceNeeded > space ? spaceNeeded : space;
        this.timestampsOn = false;
        try {
            LruCache.LruCacheEntry entry = this.entryQueueTail;
            while (this.currentSpace + spaceNeeded > this.spaceLimit && entry != null) {
                this.privateRemoveEntry(entry, false, false);
                entry = entry.previous;
            }
        }
        finally {
            this.timestampsOn = true;
        }
        if (this.currentSpace + space <= this.spaceLimit) {
            this.overflow = 0;
            return true;
        }
        this.overflow = this.currentSpace + space - this.spaceLimit;
        return false;
    }

    @Override
    protected void privateRemoveEntry(LruCache.LruCacheEntry<K, V> entry, boolean shuffle) {
        this.privateRemoveEntry(entry, shuffle, true);
    }

    protected void privateRemoveEntry(LruCache.LruCacheEntry<K, V> entry, boolean shuffle, boolean external) {
        if (!shuffle && !external) {
            if (!this.close(entry)) {
                return;
            }
            if (this.entryTable.get(entry.key) == null) {
                return;
            }
        }
        super.privateRemoveEntry(entry, shuffle);
    }

    @Override
    protected void updateTimestamp(LruCache.LruCacheEntry<K, V> entry) {
        if (this.timestampsOn) {
            super.updateTimestamp(entry);
        }
    }
}

