/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.examples.adapter.JavaElementDelta;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.IModelImpl;
import org.eclipse.handly.model.impl.support.ElementChangeEvent;
import org.eclipse.handly.model.impl.support.NotificationManager;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;

public class AdapterModelManager
implements IModelImpl,
IElementChangedListener {
    public static final AdapterModelManager INSTANCE = new AdapterModelManager();
    private NotificationManager notificationManager;

    public void startup() throws Exception {
        try {
            this.notificationManager = new NotificationManager();
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() throws Exception {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.notificationManager = null;
    }

    public IContext getModelContext_() {
        return Contexts.EMPTY_CONTEXT;
    }

    public int getModelApiLevel_() {
        return 0;
    }

    public NotificationManager getNotificationManager() {
        if (this.notificationManager == null) {
            throw new IllegalStateException();
        }
        return this.notificationManager;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.getNotificationManager().fireElementChangeEvent(AdapterModelManager.convert(event));
    }

    private static IElementChangeEvent convert(ElementChangedEvent event) {
        int type = event.getType();
        int convertedType = 0;
        if ((type & 1) != 0) {
            convertedType |= 1;
        }
        if ((type & 4) != 0) {
            convertedType |= 2;
        }
        JavaElementDelta convertedDelta = new JavaElementDelta(event.getDelta());
        return new ElementChangeEvent(convertedType, (IElementDelta)convertedDelta);
    }

    private AdapterModelManager() {
    }
}

