/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.examples.adapter.Activator;
import org.eclipse.handly.internal.examples.adapter.JavaElement;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;

class JavaSourceElement
extends JavaElement
implements ISourceElementImpl {
    public JavaSourceElement(IJavaElement javaElement) {
        super(javaElement);
        if (!(javaElement instanceof ISourceReference)) {
            throw new IllegalArgumentException();
        }
    }

    public ISourceElement getSourceElementAt_(int position, IContext context, IProgressMonitor monitor) {
        IJavaElement result;
        ISourceRange sourceRange;
        IJavaElement javaElement = this.getJavaElement();
        ISourceReference sourceRef = (ISourceReference)javaElement;
        try {
            sourceRange = sourceRef.getSourceRange();
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                Activator.log(e.getStatus());
            }
            return null;
        }
        if (position < sourceRange.getOffset() || position > sourceRange.getOffset() + sourceRange.getLength()) {
            return null;
        }
        ITypeRoot typeRoot = null;
        if (javaElement instanceof ITypeRoot) {
            typeRoot = (ITypeRoot)javaElement;
        } else {
            typeRoot = (ITypeRoot)javaElement.getAncestor(5);
            if (typeRoot == null) {
                typeRoot = (ITypeRoot)javaElement.getAncestor(6);
            }
        }
        if (typeRoot == null) {
            return null;
        }
        try {
            result = typeRoot.getElementAt(position);
            if (result == null) {
                result = javaElement;
            }
        }
        catch (JavaModelException e) {
            if (!e.isDoesNotExist()) {
                Activator.log(e.getStatus());
            }
            return null;
        }
        IElement element = JavaSourceElement.create(result);
        if (!(element instanceof ISourceElement)) {
            return null;
        }
        return (ISourceElement)element;
    }

    public ISourceElementInfo getSourceElementInfo_(IContext context, IProgressMonitor monitor) throws CoreException {
        ISourceReference sourceRef = (ISourceReference)this.getJavaElement();
        final String source = sourceRef.getSource();
        ISourceRange sourceRange = sourceRef.getSourceRange();
        ISourceRange nameRange = sourceRef.getNameRange();
        ISourceConstruct[] children = (ISourceConstruct[])this.getChildrenOfType_(ISourceConstruct.class, context, monitor);
        Snapshot snapshot = source == null ? null : new Snapshot(){

            public String getContents() {
                return source;
            }
        };
        TextRange fullRange = JavaSourceElement.toTextRange(sourceRange);
        TextRange identifyingRange = JavaSourceElement.toTextRange(nameRange);
        return new ISourceElementInfo((ISnapshot)snapshot, children, fullRange, identifyingRange){
            private final /* synthetic */ ISnapshot val$snapshot;
            private final /* synthetic */ ISourceConstruct[] val$children;
            private final /* synthetic */ TextRange val$fullRange;
            private final /* synthetic */ TextRange val$identifyingRange;
            {
                this.val$snapshot = iSnapshot;
                this.val$children = iSourceConstructArray;
                this.val$fullRange = textRange;
                this.val$identifyingRange = textRange2;
            }

            public ISnapshot getSnapshot() {
                return this.val$snapshot;
            }

            public ISourceConstruct[] getChildren() {
                return this.val$children;
            }

            public TextRange getFullRange() {
                return this.val$fullRange;
            }

            public TextRange getIdentifyingRange() {
                return this.val$identifyingRange;
            }

            public <T> T get(Property<T> property) {
                return null;
            }
        };
    }

    private static TextRange toTextRange(ISourceRange sourceRange) {
        if (!SourceRange.isAvailable((ISourceRange)sourceRange)) {
            return null;
        }
        return new TextRange(sourceRange.getOffset(), sourceRange.getLength());
    }
}

