/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.adapter;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.buffer.TextFileBuffer;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.examples.adapter.Activator;
import org.eclipse.handly.internal.examples.adapter.JavaSourceElement;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.ISourceFileImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;

class JavaSourceFile
extends JavaSourceElement
implements ISourceFileImpl {
    public JavaSourceFile(ICompilationUnit compilationUnit) {
        super((IJavaElement)compilationUnit);
    }

    public ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getJavaElement();
    }

    public IFile getFile_() {
        return (IFile)this.getCompilationUnit().getResource();
    }

    public boolean isWorkingCopy_() {
        return this.getCompilationUnit().isWorkingCopy();
    }

    public boolean needsReconciling_() {
        try {
            return !this.getCompilationUnit().isConsistent();
        }
        catch (JavaModelException e) {
            Activator.log(e.getStatus());
            return false;
        }
    }

    public void reconcile_(IContext context, IProgressMonitor monitor) throws CoreException {
        this.getCompilationUnit().reconcile(0, ((Boolean)context.getOrDefault(Elements.FORCE_RECONCILING)).booleanValue(), null, monitor);
    }

    public IBuffer getBuffer_(IContext context, IProgressMonitor monitor) throws CoreException {
        IFile file = this.getFile_();
        if (file == null) {
            throw new AssertionError((Object)("No underlying IFile for " + this.toString()));
        }
        ICoreTextFileBufferProvider provider = ICoreTextFileBufferProvider.forLocation((IPath)file.getFullPath(), (LocationKind)LocationKind.IFILE, (ITextFileBufferManager)ITextFileBufferManager.DEFAULT);
        if (!((Boolean)context.getOrDefault(Elements.CREATE_BUFFER)).booleanValue() && provider.getBuffer() == null) {
            return null;
        }
        return new TextFileBuffer(provider, monitor);
    }
}

