/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.SaveMode;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFile;
import org.eclipse.handly.junit.WorkspaceTestCase;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FooWorkingCopyTest
extends WorkspaceTestCase {
    private FooFile workingCopy;

    protected void setUp() throws Exception {
        super.setUp();
        IFooProject fooProject = FooModelCore.create((IProject)this.setUpProject("Test002"));
        this.workingCopy = (FooFile)fooProject.getFooFile("test.foo");
    }

    public void test1() throws Exception {
        this.doWithWorkingCopy(Contexts.EMPTY_CONTEXT, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooDef[] defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                IFooDef def = FooWorkingCopyTest.this.workingCopy.getDef("f", 0);
                FooWorkingCopyTest.assertEquals((Object)def, (Object)defs[0]);
                TextRange r = defs[0].getSourceElementInfo().getIdentifyingRange();
                BufferChange change = new BufferChange((TextEdit)new ReplaceEdit(r.getOffset(), r.getLength(), "g"));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                Throwable throwable = null;
                Object var7_8 = null;
                try (IBuffer buffer = FooWorkingCopyTest.this.workingCopy.getBuffer();){
                    buffer.applyChange((IBufferChange)change, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                FooWorkingCopyTest.assertEquals((Object)def, (Object)defs[0]);
                FooWorkingCopyTest.this.workingCopy.reconcile(null);
                FooWorkingCopyTest.assertFalse((boolean)def.exists());
                defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                FooWorkingCopyTest.assertEquals((Object)FooWorkingCopyTest.this.workingCopy.getDef("g", 0), (Object)defs[0]);
            }
        });
    }

    public void test2() throws Exception {
        this.doWithWorkingCopy(Contexts.EMPTY_CONTEXT, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IBuffer buffer;
                IFooVar[] vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                IFooVar var1 = FooWorkingCopyTest.this.workingCopy.getVar("x");
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[0]);
                IFooVar var2 = FooWorkingCopyTest.this.workingCopy.getVar("y");
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[1]);
                ISourceElementInfo info = var2.getSourceElementInfo();
                TextRange r = info.getFullRange();
                String var2Text = info.getSnapshot().getContents().substring(r.getOffset(), r.getEndOffset());
                BufferChange change = new BufferChange((TextEdit)new DeleteEdit(r.getOffset(), r.getLength()));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                Throwable throwable = null;
                Object var10_12 = null;
                try {
                    buffer = FooWorkingCopyTest.this.workingCopy.getBuffer();
                    try {
                        buffer.applyChange((IBufferChange)change, null);
                    }
                    finally {
                        if (buffer != null) {
                            buffer.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[1]);
                FooWorkingCopyTest.this.workingCopy.reconcile(null);
                FooWorkingCopyTest.assertFalse((boolean)var2.exists());
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)1, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[0]);
                info = var1.getSourceElementInfo();
                r = info.getFullRange();
                change = new BufferChange((TextEdit)new InsertEdit(r.getOffset(), var2Text));
                change.setSaveMode(SaveMode.LEAVE_UNSAVED);
                throwable = null;
                var10_12 = null;
                try {
                    buffer = FooWorkingCopyTest.this.workingCopy.getBuffer();
                    try {
                        buffer.applyChange((IBufferChange)change, null);
                    }
                    finally {
                        if (buffer != null) {
                            buffer.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)1, (int)vars.length);
                FooWorkingCopyTest.this.workingCopy.reconcile(null);
                vars = FooWorkingCopyTest.this.workingCopy.getVars();
                FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                FooWorkingCopyTest.assertEquals((Object)var2, (Object)vars[0]);
                FooWorkingCopyTest.assertEquals((Object)var1, (Object)vars[1]);
            }
        });
    }

    public void testBug480397_1() throws Exception {
        this.workingCopy.getParent().getResource().delete(true, null);
        Throwable throwable = null;
        Object var2_3 = null;
        try (Buffer buffer = new Buffer("var x; var y; def f() {} def f(x) {} def f(x, y) {}");){
            this.doWithWorkingCopy(Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)buffer), new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    FooWorkingCopyTest.assertFalse((boolean)FooWorkingCopyTest.this.workingCopy.getParent().exists());
                    FooWorkingCopyTest.assertTrue((boolean)FooWorkingCopyTest.this.workingCopy.exists());
                    IFooVar[] vars = FooWorkingCopyTest.this.workingCopy.getVars();
                    FooWorkingCopyTest.assertEquals((int)2, (int)vars.length);
                    IFooDef[] defs = FooWorkingCopyTest.this.workingCopy.getDefs();
                    FooWorkingCopyTest.assertEquals((int)3, (int)defs.length);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testBug480397_2() throws Exception {
        this.doWithWorkingCopy(Contexts.EMPTY_CONTEXT, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FooWorkingCopyTest.this.workingCopy.close_();
                FooWorkingCopyTest.assertNotNull((String)"working copy must remain in the cache", (Object)FooWorkingCopyTest.this.workingCopy.peekAtBody_());
                FooWorkingCopyTest.this.workingCopy.getParent().close_();
                FooWorkingCopyTest.assertNotNull((String)"working copy must remain in the cache", (Object)FooWorkingCopyTest.this.workingCopy.peekAtBody_());
            }
        });
    }

    public void testBug480397_3() throws Exception {
        IWorkspaceRunnable testRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFooDef def = FooWorkingCopyTest.this.workingCopy.getDef("f", 0);
                FooWorkingCopyTest.assertTrue((boolean)def.exists());
                ((IElementImplExtension)def).close_();
                FooWorkingCopyTest.assertNotNull((String)"non-openable elements cannot be closed", (Object)((IElementImplExtension)def).peekAtBody_());
            }
        };
        this.doWithWorkingCopy(Contexts.EMPTY_CONTEXT, testRunnable);
        testRunnable.run(null);
    }

    private void doWithWorkingCopy(IContext context, IWorkspaceRunnable runnable) throws CoreException {
        this.workingCopy.becomeWorkingCopy_(context, null);
        try {
            runnable.run(null);
        }
        finally {
            this.workingCopy.releaseWorkingCopy_();
        }
    }
}

