/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui;

import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.xtext.util.Strings;

public class FooLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public StyledString getStyledText(Object element) {
        String text = this.getText(element);
        if (text == null) {
            return new StyledString();
        }
        return new StyledString(text);
    }

    public String getText(Object element) {
        if (element instanceof IFooDef) {
            IFooDef def = (IFooDef)element;
            if (def.getArity() == 0) {
                return String.valueOf(def.getName()) + "()";
            }
            try {
                return String.valueOf(def.getName()) + '(' + Strings.concat((String)", ", Arrays.asList(def.getParameterNames())) + ')';
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (element instanceof IFooElement) {
            return ((IFooElement)element).getName();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        IWorkbenchAdapter adapter;
        if (element instanceof IFooDef) {
            return Activator.getImage("org.eclipse.handly.examples.basic.ui/obj16/def.gif");
        }
        if (element instanceof IFooVar) {
            return Activator.getImage("org.eclipse.handly.examples.basic.ui/obj16/var.gif");
        }
        IResource resource = null;
        if (element instanceof IFooProject || element instanceof IFooFile) {
            resource = ((IFooElement)element).getResource();
        }
        if (element instanceof IResource) {
            resource = (IResource)element;
        }
        if (resource != null && (adapter = (IWorkbenchAdapter)resource.getAdapter(IWorkbenchAdapter.class)) != null) {
            return (Image)this.resourceManager.get((DeviceResourceDescriptor)adapter.getImageDescriptor((Object)resource));
        }
        return super.getImage(element);
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

