/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.examples.basic.ui.model.FooModelCore;
import org.eclipse.handly.examples.basic.ui.model.IFooElement;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProjectBody;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.support.Body;
import org.eclipse.handly.model.impl.support.ElementDelta;

class FooDeltaProcessor
implements IResourceDeltaVisitor {
    private ElementDelta.Builder builder = new ElementDelta.Builder(new ElementDelta((IElement)FooModelCore.getFooModel()));
    private Set<String> oldFooProjectNames = new HashSet<String>();

    FooDeltaProcessor() {
    }

    public IElementDelta getDelta() {
        return this.builder.getDelta();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        switch (delta.getResource().getType()) {
            case 8: {
                return this.processRoot(delta);
            }
            case 4: {
                return this.processProject(delta);
            }
            case 2: {
                return this.processFolder(delta);
            }
            case 1: {
                return this.processFile(delta);
            }
        }
        return true;
    }

    private boolean processRoot(IResourceDelta delta) throws CoreException {
        this.initOldFooProjectNames();
        if ((delta.getFlags() & 0x20000) != 0) {
            this.builder.markersChanged((IElement)FooModelCore.getFooModel(), delta.getMarkerDeltas());
        }
        return true;
    }

    private boolean processProject(IResourceDelta delta) throws CoreException {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedProject(delta);
            }
            case 2: {
                return this.processRemovedProject(delta);
            }
            case 4: {
                return this.processChangedProject(delta);
            }
        }
        return true;
    }

    private boolean processAddedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
            IFooProject fooProject = FooModelCore.create(project);
            this.addToModel(fooProject);
            this.translateAddedDelta(delta, fooProject);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processRemovedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        if (this.wasFooProject(project)) {
            IFooProject fooProject = FooModelCore.create(project);
            this.removeFromModel(fooProject);
            this.translateRemovedDelta(delta, fooProject);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processChangedProject(IResourceDelta delta) throws CoreException {
        IProject project = (IProject)delta.getResource();
        IFooProject fooProject = FooModelCore.create(project);
        if ((delta.getFlags() & 0x4000) != 0) {
            if (project.isOpen()) {
                if (project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature")) {
                    this.addToModel(fooProject);
                    this.builder.added((IElement)fooProject, 64L);
                } else {
                    this.addResourceDelta(delta);
                }
            } else if (this.wasFooProject(project)) {
                this.removeFromModel(fooProject);
                this.builder.removed((IElement)fooProject, 64L);
            } else {
                this.addResourceDelta(delta);
            }
            return false;
        }
        boolean isFooProject = project.hasNature("org.eclipse.handly.examples.basic.ui.fooNature");
        if ((delta.getFlags() & 0x80000) != 0) {
            boolean wasFooProject = this.wasFooProject(project);
            if (wasFooProject != isFooProject) {
                if (isFooProject) {
                    this.addToModel(fooProject);
                    this.builder.added((IElement)fooProject, 128L);
                } else {
                    this.removeFromModel(fooProject);
                    this.builder.removed((IElement)fooProject, 128L);
                }
                return false;
            }
            if (isFooProject) {
                this.builder.changed((IElement)fooProject, 128L);
            }
        }
        if (isFooProject) {
            Body parentBody;
            IElement[] children;
            if ((delta.getFlags() & 0x20000) != 0) {
                this.builder.markersChanged((IElement)fooProject, delta.getMarkerDeltas());
            }
            if (!Arrays.asList(children = (parentBody = FooDeltaProcessor.findBody(fooProject.getParent())).getChildren()).contains(fooProject)) {
                this.addToModel(fooProject);
            }
            return true;
        }
        this.addResourceDelta(delta);
        return false;
    }

    private boolean processFolder(IResourceDelta delta) {
        this.addResourceDelta(delta);
        return false;
    }

    private boolean processFile(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                return this.processAddedFile(delta);
            }
            case 2: {
                return this.processRemovedFile(delta);
            }
            case 4: {
                return this.processChangedFile(delta);
            }
        }
        return false;
    }

    private boolean processAddedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IFooFile fooFile = FooModelCore.create(file);
        if (fooFile != null) {
            this.addToModel(fooFile);
            this.translateAddedDelta(delta, fooFile);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processRemovedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IFooFile fooFile = FooModelCore.create(file);
        if (fooFile != null) {
            this.removeFromModel(fooFile);
            this.translateRemovedDelta(delta, fooFile);
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private boolean processChangedFile(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        IFooFile fooFile = FooModelCore.create(file);
        if (fooFile != null) {
            if ((delta.getFlags() & 0xFFFCFFFF) != 0) {
                this.contentChanged(fooFile);
            }
            if ((delta.getFlags() & 0x20000) != 0) {
                this.builder.markersChanged((IElement)fooFile, delta.getMarkerDeltas());
            }
            if ((delta.getFlags() & 0x10000) != 0) {
                this.builder.changed((IElement)fooFile, 2048L);
            }
        } else {
            this.addResourceDelta(delta);
        }
        return false;
    }

    private void initOldFooProjectNames() throws CoreException {
        IFooProject[] fooProjects;
        IFooProject[] iFooProjectArray = fooProjects = FooModelCore.getFooModel().getFooProjects();
        int n = fooProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IFooProject fooProject = iFooProjectArray[n2];
            this.oldFooProjectNames.add(fooProject.getName());
            ++n2;
        }
    }

    private boolean wasFooProject(IProject project) {
        return this.oldFooProjectNames.contains(project.getName());
    }

    private void addToModel(IFooElement element) {
        Body parentBody = FooDeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            parentBody.addChild((IElement)element);
        }
        FooDeltaProcessor.close(element);
    }

    private void removeFromModel(IFooElement element) {
        Body parentBody = FooDeltaProcessor.findBody(element.getParent());
        if (parentBody != null) {
            parentBody.removeChild((IElement)element);
        }
        FooDeltaProcessor.close(element);
    }

    private void translateAddedDelta(IResourceDelta delta, IFooElement element) {
        if ((delta.getFlags() & 0x1000) == 0) {
            this.builder.added((IElement)element);
        } else {
            IFooElement movedFromElement = FooModelCore.create(FooDeltaProcessor.getResource(delta.getMovedFromPath(), delta.getResource().getType()));
            if (movedFromElement == null) {
                this.builder.added((IElement)element);
            } else {
                this.builder.movedTo((IElement)element, (IElement)movedFromElement);
            }
        }
    }

    private void translateRemovedDelta(IResourceDelta delta, IFooElement element) {
        if ((delta.getFlags() & 0x2000) == 0) {
            this.builder.removed((IElement)element);
        } else {
            IFooElement movedToElement = FooModelCore.create(FooDeltaProcessor.getResource(delta.getMovedToPath(), delta.getResource().getType()));
            if (movedToElement == null) {
                this.builder.removed((IElement)element);
            } else {
                this.builder.movedFrom((IElement)element, (IElement)movedToElement);
            }
        }
    }

    private void contentChanged(IFooFile fooFile) {
        if (fooFile.isWorkingCopy()) {
            this.builder.changed((IElement)fooFile, 513L);
            return;
        }
        FooDeltaProcessor.close(fooFile);
        this.builder.changed((IElement)fooFile, 1L);
    }

    private void addResourceDelta(IResourceDelta resourceDelta) {
        IFooElement element;
        IContainer parent = resourceDelta.getResource().getParent();
        if (parent instanceof IWorkspaceRoot) {
            element = FooModelCore.getFooModel();
        } else if (parent instanceof IProject) {
            FooProjectBody body;
            element = FooModelCore.create((IProject)parent);
            if ((resourceDelta.getKind() & 3) != 0 && (body = (FooProjectBody)FooDeltaProcessor.findBody(element)) != null) {
                body.setNonFooResources(null);
            }
        } else {
            throw new AssertionError();
        }
        this.builder.addResourceDelta((IElement)element, resourceDelta);
    }

    private static Body findBody(IFooElement element) {
        return (Body)((IElementImplExtension)element).findBody_();
    }

    private static void close(IFooElement element) {
        ((IElementImplExtension)element).close_();
    }

    private static IResource getResource(IPath fullPath, int resourceType) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        switch (resourceType) {
            case 8: {
                return root;
            }
            case 4: {
                return root.getProject(fullPath.lastSegment());
            }
            case 2: {
                return root.getFolder(fullPath);
            }
            case 1: {
                return root.getFile(fullPath);
            }
        }
        return null;
    }
}

