/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.basic.foo.Module;
import org.eclipse.handly.examples.basic.ui.model.IFooDef;
import org.eclipse.handly.examples.basic.ui.model.IFooFile;
import org.eclipse.handly.examples.basic.ui.model.IFooVar;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.internal.examples.basic.ui.model.FooDef;
import org.eclipse.handly.internal.examples.basic.ui.model.FooFileStructureBuilder;
import org.eclipse.handly.internal.examples.basic.ui.model.FooProject;
import org.eclipse.handly.internal.examples.basic.ui.model.FooVar;
import org.eclipse.handly.internal.examples.basic.ui.model.IFooElementInternal;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.model.impl.support.WorkspaceSourceFile;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class FooFile
extends WorkspaceSourceFile
implements IFooFile,
IFooElementInternal {
    public FooFile(FooProject parent, IFile file) {
        super((IElement)parent, file);
        if (!file.getParent().equals((Object)parent.getProject())) {
            throw new IllegalArgumentException();
        }
        if (!"foo".equals(file.getFileExtension())) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public FooProject getParent() {
        return (FooProject)this.getParent_();
    }

    @Override
    public IFooVar getVar(String name) {
        return new FooVar(this, name);
    }

    @Override
    public IFooVar[] getVars() throws CoreException {
        return (IFooVar[])this.getChildren(IFooVar.class);
    }

    @Override
    public IFooDef getDef(String name, int arity) {
        return new FooDef(this, name, arity);
    }

    @Override
    public IFooDef[] getDefs() throws CoreException {
        return (IFooDef[])this.getChildren(IFooDef.class);
    }

    public void buildSourceStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
        EObject root;
        IParseResult parseResult;
        Map newElements = (Map)context.get(NEW_ELEMENTS);
        SourceElementBody body = new SourceElementBody();
        XtextResource resource = (XtextResource)context.get(SOURCE_AST);
        if (resource == null) {
            try {
                resource = this.parse((String)context.get(SOURCE_CONTENTS), this.getFile().getCharset());
            }
            catch (IOException e) {
                throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
            }
        }
        if ((parseResult = resource.getParseResult()) != null && (root = parseResult.getRootASTElement()) instanceof Module) {
            FooFileStructureBuilder builder = new FooFileStructureBuilder(newElements, resource.getResourceServiceProvider());
            builder.buildStructure(this, body, (Module)root, monitor);
        }
        newElements.put(this, body);
    }

    protected XtextResource parse(String contents, String encoding) throws IOException {
        IResourceSetProvider resourceSetProvider = (IResourceSetProvider)this.getResourceServiceProvider().get(IResourceSetProvider.class);
        ResourceSet resourceSet = resourceSetProvider.get(this.getFile().getProject());
        XtextResource resource = (XtextResource)resourceSet.createResource(this.getResourceUri());
        resource.load((InputStream)new ByteArrayInputStream(contents.getBytes(encoding)), Collections.singletonMap(XtextResource.OPTION_ENCODING, encoding));
        return resource;
    }

    protected IResourceServiceProvider getResourceServiceProvider() {
        IResourceServiceProvider provider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(this.getResourceUri());
        if (provider == null) {
            throw new AssertionError();
        }
        return provider;
    }

    protected URI getResourceUri() {
        return URI.createPlatformResourceURI((String)this.getFile().getFullPath().toString(), (boolean)true);
    }
}

