/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.basic.ui.model;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.examples.basic.ui.Activator;
import org.eclipse.handly.internal.examples.basic.ui.model.FooDeltaProcessor;
import org.eclipse.handly.internal.examples.basic.ui.model.FooElementHandleFactory;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModel;
import org.eclipse.handly.internal.examples.basic.ui.model.FooModelCache;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.IElementHandleFactory;
import org.eclipse.handly.model.impl.support.ElementChangeEvent;
import org.eclipse.handly.model.impl.support.ElementManager;
import org.eclipse.handly.model.impl.support.IBodyCache;
import org.eclipse.handly.model.impl.support.IModelManager;
import org.eclipse.handly.model.impl.support.INotificationManager;
import org.eclipse.handly.model.impl.support.NotificationManager;
import org.eclipse.handly.util.SavedStateJob;

public class FooModelManager
implements IModelManager,
IResourceChangeListener {
    public static final FooModelManager INSTANCE = new FooModelManager();
    private FooModel fooModel;
    private ElementManager elementManager;
    private NotificationManager notificationManager;
    private Context modelContext;

    public void startup() throws Exception {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.fooModel = new FooModel(workspace);
            this.elementManager = new ElementManager((IBodyCache)new FooModelCache());
            this.notificationManager = new NotificationManager();
            this.modelContext = new Context();
            this.modelContext.bind(INotificationManager.class).to((Object)this.notificationManager);
            this.modelContext.bind(IElementHandleFactory.class).to((Object)new FooElementHandleFactory());
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            new SavedStateJob("org.eclipse.handly.examples.basic.ui", (IResourceChangeListener)this).schedule();
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.modelContext = null;
        this.notificationManager = null;
        this.elementManager = null;
        this.fooModel = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        FooDeltaProcessor deltaProcessor = new FooDeltaProcessor();
        try {
            event.getDelta().accept((IResourceDeltaVisitor)deltaProcessor);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        IElementDelta delta = deltaProcessor.getDelta();
        if (!ElementDeltas.isEmpty((IElementDelta)delta)) {
            this.getNotificationManager().fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, delta));
        }
    }

    public FooModel getModel() {
        if (this.fooModel == null) {
            throw new IllegalStateException();
        }
        return this.fooModel;
    }

    public ElementManager getElementManager() {
        if (this.elementManager == null) {
            throw new IllegalStateException();
        }
        return this.elementManager;
    }

    public NotificationManager getNotificationManager() {
        if (this.notificationManager == null) {
            throw new IllegalStateException();
        }
        return this.notificationManager;
    }

    public IContext getModelContext() {
        if (this.modelContext == null) {
            throw new IllegalStateException();
        }
        return this.modelContext;
    }

    private FooModelManager() {
    }
}

