/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.examples.jmodel.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.jmodel.ICompilationUnit;
import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.examples.jmodel.IJavaModel;
import org.eclipse.handly.examples.jmodel.IJavaProject;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.handly.examples.jmodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.jmodel.JavaModelCore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class JavaModelContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children3;
        if (parentElement instanceof IJavaModel) {
            try {
                Object[] javaProjects = ((IJavaModel)parentElement).getJavaProjects();
                Object[] nonJavaProjects = ((IJavaModel)parentElement).getNonJavaProjects();
                return JavaModelContentProvider.concat(javaProjects, nonJavaProjects);
            }
            catch (CoreException javaProjects) {
                // empty catch block
            }
        }
        if (parentElement instanceof IJavaProject) {
            try {
                Object[] children2 = ((IJavaElement)parentElement).getChildren();
                Object[] nonJavaResources = ((IJavaProject)parentElement).getNonJavaResources();
                return JavaModelContentProvider.concat(children2, nonJavaResources);
            }
            catch (CoreException children2) {
                // empty catch block
            }
        }
        if (parentElement instanceof IPackageFragmentRoot) {
            try {
                children3 = ((IPackageFragmentRoot)parentElement).getPackageFragments();
                Object[] nonJavaResources = ((IPackageFragmentRoot)parentElement).getNonJavaResources();
                return JavaModelContentProvider.concat(children3, nonJavaResources);
            }
            catch (CoreException children3) {
                // empty catch block
            }
        }
        if (parentElement instanceof IPackageFragment) {
            try {
                children3 = ((IPackageFragment)parentElement).getCompilationUnits();
                Object[] nonJavaResources = ((IPackageFragment)parentElement).getNonJavaResources();
                return JavaModelContentProvider.concat(children3, nonJavaResources);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (parentElement instanceof ICompilationUnit) {
            try {
                return ((ICompilationUnit)parentElement).getTypes();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (parentElement instanceof IJavaElement) {
            try {
                return ((IJavaElement)parentElement).getChildren();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (parentElement instanceof IContainer) {
            try {
                return ((IContainer)parentElement).members();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        if (element instanceof IResource) {
            IContainer parent = ((IResource)element).getParent();
            IJavaElement javaParent = JavaModelCore.create((IResource)parent);
            if (javaParent != null && javaParent.exists()) {
                return javaParent;
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    private static Object[] concat(Object[] a, Object[] b) {
        Object[] c = new Object[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }
}

