/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.examples.jmodel.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.internal.examples.jmodel.ui.Activator;
import org.eclipse.handly.internal.examples.jmodel.ui.JavaElementImageProvider;
import org.eclipse.handly.internal.examples.jmodel.ui.JavaElementLabelComposer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaModelLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private JavaElementImageProvider imageProvider = new JavaElementImageProvider();

    public StyledString getStyledText(Object element) {
        if (element instanceof IJavaElement) {
            try {
                StyledString ss = new StyledString();
                JavaElementLabelComposer.create(ss).appendElementLabel((IJavaElement)element);
                return ss;
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
        return new StyledString(this.getText(element));
    }

    public String getText(Object element) {
        IWorkbenchAdapter wbadapter;
        if (element instanceof IJavaElement) {
            try {
                StringBuilder sb = new StringBuilder();
                JavaElementLabelComposer.create(sb).appendElementLabel((IJavaElement)element);
                return sb.toString();
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        } else if (element instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(element);
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        try {
            return this.imageProvider.getImage(element);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
            return super.getImage(element);
        }
    }
}

