/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.handly.examples.jmodel.ICompilationUnit;
import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.examples.jmodel.IJavaModel;
import org.eclipse.handly.examples.jmodel.IJavaProject;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.handly.examples.jmodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.jmodel.IType;
import org.eclipse.handly.internal.examples.jmodel.ui.JavaElementContainmentAdapter;
import org.eclipse.handly.internal.examples.jmodel.ui.PersistableJavaElementFactory;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IPersistableElement;

public class JavaElementAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{IResource.class, IPersistableElement.class, IContainmentAdapter.class};
    private static final IContainmentAdapter CONTAINMENT_ADAPTER = new JavaElementContainmentAdapter();

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public <T> T getAdapter(Object element, Class<T> adapterType) {
        if (adapterType == IResource.class) {
            return (T)this.getResource((IJavaElement)element);
        }
        if (adapterType == IPersistableElement.class) {
            return (T)new PersistableJavaElementFactory((IJavaElement)element);
        }
        if (adapterType == IContainmentAdapter.class) {
            return (T)CONTAINMENT_ADAPTER;
        }
        return null;
    }

    private IResource getResource(IJavaElement element) {
        if (element instanceof IType) {
            IJavaElement parent = element.getParent();
            if (parent instanceof ICompilationUnit) {
                return parent.getResource();
            }
        } else if (element instanceof ICompilationUnit || element instanceof IPackageFragment || element instanceof IPackageFragmentRoot || element instanceof IJavaProject || element instanceof IJavaModel) {
            return element.getResource();
        }
        return null;
    }
}

