/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.handly.internal.examples.jmodel.ui.Activator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class JavaElementImageDescriptor
extends CompositeImageDescriptor {
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final int ABSTRACT = 1;
    public static final int FINAL = 2;
    public static final int SYNCHRONIZED = 4;
    public static final int STATIC = 8;
    public static final int IMPLEMENTS = 256;
    public static final int CONSTRUCTOR = 512;
    public static final int VOLATILE = 2048;
    public static final int TRANSIENT = 4096;
    public static final int NATIVE = 16384;
    private ImageDescriptor fBaseImage;
    private int fFlags;

    public JavaElementImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public boolean equals(Object object) {
        if (object == null || !JavaElementImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        JavaElementImageDescriptor other = (JavaElementImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags;
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags;
    }

    protected Point getSize() {
        return SMALL_SIZE;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            Activator.log((IStatus)new Status(4, "org.eclipse.handly.examples.jmodel.ui", "Image data not available: " + descriptor.toString()));
        }
        return data;
    }

    private void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    private void drawTopRight() {
        Point pos = new Point(this.getSize().x, 0);
        if ((this.fFlags & 1) != 0) {
            this.addTopRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/abstract_co.gif"), pos);
        }
        if ((this.fFlags & 0x200) != 0) {
            this.addTopRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/constr_ovr.gif"), pos);
        }
        if ((this.fFlags & 2) != 0) {
            this.addTopRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/final_co.gif"), pos);
        }
        if ((this.fFlags & 0x800) != 0) {
            this.addTopRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/volatile_co.gif"), pos);
        }
        if ((this.fFlags & 8) != 0) {
            this.addTopRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/static_co.gif"), pos);
        }
        if ((this.fFlags & 0x4000) != 0) {
            this.addTopRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/native_co.gif"), pos);
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        Point pos = new Point(size.x, size.y);
        int flags = this.fFlags;
        int syncAndImpl = 260;
        if ((flags & syncAndImpl) == syncAndImpl) {
            this.addBottomRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/sync_impl.gif"), pos);
            flags &= ~syncAndImpl;
        }
        if ((flags & 0x100) != 0) {
            this.addBottomRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/implm_co.gif"), pos);
        }
        if ((flags & 4) != 0) {
            this.addBottomRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/synch_co.gif"), pos);
        }
        if ((flags & 0x1000) != 0) {
            this.addBottomRightImage(Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/ovr16/transient_co.gif"), pos);
        }
    }
}

