/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.examples.jmodel.ICompilationUnit;
import org.eclipse.handly.examples.jmodel.IField;
import org.eclipse.handly.examples.jmodel.IImportContainer;
import org.eclipse.handly.examples.jmodel.IImportDeclaration;
import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.examples.jmodel.IJavaModel;
import org.eclipse.handly.examples.jmodel.IJavaProject;
import org.eclipse.handly.examples.jmodel.IMember;
import org.eclipse.handly.examples.jmodel.IMethod;
import org.eclipse.handly.examples.jmodel.IPackageDeclaration;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.handly.examples.jmodel.IPackageFragmentRoot;
import org.eclipse.handly.examples.jmodel.IType;
import org.eclipse.handly.internal.examples.jmodel.ui.Activator;
import org.eclipse.handly.internal.examples.jmodel.ui.ImageDescriptorRegistry;
import org.eclipse.handly.internal.examples.jmodel.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementImageProvider {
    public Image getImage(Object element) throws CoreException {
        ImageDescriptor descriptor = JavaElementImageProvider.getDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        return JavaElementImageProvider.getRegistry().get(descriptor);
    }

    private static ImageDescriptor getDescriptor(Object element) throws CoreException {
        if (element instanceof IJavaElement) {
            return JavaElementImageProvider.getJavaImageDescriptor((IJavaElement)element);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (JavaCore.isJavaLikeFileName((String)file.getName())) {
                return JavaElementImageProvider.getCUResourceImageDescriptor(file);
            }
            return JavaElementImageProvider.getWorkbenchImageDescriptor((IAdaptable)file);
        }
        if (element instanceof IAdaptable) {
            return JavaElementImageProvider.getWorkbenchImageDescriptor((IAdaptable)element);
        }
        return null;
    }

    private static ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        return wbAdapter.getImageDescriptor((Object)adaptable);
    }

    private static ImageDescriptor getCUResourceImageDescriptor(IFile file) {
        return Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/obj16/jcu_resource_obj.gif");
    }

    private static ImageDescriptor getJavaImageDescriptor(IJavaElement element) throws CoreException {
        ImageDescriptor baseDesc = JavaElementImageProvider.getBaseImageDescriptor(element);
        if (baseDesc != null) {
            int adornmentFlags = JavaElementImageProvider.computeJavaAdornmentFlags(element);
            return new JavaElementImageDescriptor(baseDesc, adornmentFlags);
        }
        return null;
    }

    private static ImageDescriptor getBaseImageDescriptor(IJavaElement element) throws CoreException {
        ImageDescriptor imageDescriptor;
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            IType declType = method.getDeclaringType();
            int flags = method.getFlags();
            if (declType.isEnum() && JavaElementImageProvider.isDefaultFlag(flags) && method.isConstructor()) {
                return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpri_obj.gif");
            }
            return JavaElementImageProvider.getMethodImageDescriptor(declType.isInterface() || declType.isAnnotation(), flags);
        }
        if (element instanceof IField) {
            IMember member = (IMember)element;
            IType declType = member.getDeclaringType();
            return JavaElementImageProvider.getFieldImageDescriptor(declType.isInterface() || declType.isAnnotation(), member.getFlags());
        }
        if (element instanceof IPackageDeclaration) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.packd_obj.gif");
        }
        if (element instanceof IImportDeclaration) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.imp_obj.gif");
        }
        if (element instanceof IImportContainer) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.impc_obj.gif");
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            IType declType = type.getDeclaringType();
            boolean isInner = declType != null;
            boolean isInInterfaceOrAnnotation = isInner && (declType.isInterface() || declType.isAnnotation());
            return JavaElementImageProvider.getTypeImageDescriptor(isInner, isInInterfaceOrAnnotation, type.getFlags());
        }
        if (element instanceof IPackageFragmentRoot) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.packagefolder_obj.gif");
        }
        if (element instanceof IPackageFragment) {
            return JavaElementImageProvider.getPackageFragmentIcon(element);
        }
        if (element instanceof ICompilationUnit) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.jcu_obj.gif");
        }
        if (element instanceof IJavaProject) {
            IJavaProject jp = (IJavaProject)element;
            if (jp.getProject().isOpen()) {
                ImageDescriptor result;
                IProject project = jp.getProject();
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                    return result;
                }
                return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        }
        if (element instanceof IJavaModel) {
            return Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/obj16/java_model_obj.gif");
        }
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter != null && (imageDescriptor = wbAdapter.getImageDescriptor((Object)element)) != null) {
            return imageDescriptor;
        }
        return null;
    }

    private static int computeJavaAdornmentFlags(IJavaElement element) throws CoreException {
        int flags = 0;
        try {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                int modifiers = member.getFlags();
                if (Flags.isAbstract((int)modifiers) && JavaElementImageProvider.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || JavaElementImageProvider.isInterfaceOrAnnotationField(member) || JavaElementImageProvider.isEnumConstant(member, modifiers)) {
                    flags |= 2;
                }
                if (Flags.isStatic((int)modifiers) || JavaElementImageProvider.isInterfaceOrAnnotationFieldOrType(member) || JavaElementImageProvider.isEnumConstant(member, modifiers)) {
                    flags |= 8;
                }
                if (element instanceof IMethod) {
                    if (((IMethod)element).isConstructor()) {
                        flags |= 0x200;
                    }
                    if (Flags.isSynchronized((int)modifiers)) {
                        flags |= 4;
                    }
                    if (Flags.isNative((int)modifiers)) {
                        flags |= 0x4000;
                    }
                }
                if (element instanceof IField) {
                    if (Flags.isVolatile((int)modifiers)) {
                        flags |= 0x800;
                    }
                    if (Flags.isTransient((int)modifiers)) {
                        flags |= 0x1000;
                    }
                }
            }
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        return flags;
    }

    private static ImageDescriptorRegistry getRegistry() {
        return Activator.getImageDescriptorRegistry();
    }

    private static boolean isDefaultFlag(int flags) {
        return !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !Flags.isPrivate((int)flags);
    }

    private static ImageDescriptor getMethodImageDescriptor(boolean isInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInterfaceOrAnnotation) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpub_obj.gif");
        }
        if (Flags.isProtected((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpro_obj.gif");
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methpri_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.methdef_obj.gif");
    }

    private static ImageDescriptor getFieldImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation || Flags.isEnum((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.field_public_obj.gif");
        }
        if (Flags.isProtected((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.field_protected_obj.gif");
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.field_private_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.field_default_obj.gif");
    }

    private static ImageDescriptor getPackageFragmentIcon(IJavaElement element) throws CoreException {
        IPackageFragment fragment = (IPackageFragment)element;
        boolean containsJavaElements = false;
        boolean containsNonJavaElements = false;
        try {
            containsJavaElements = fragment.getCompilationUnits().length > 0;
            containsNonJavaElements = fragment.getNonJavaResources().length > 0;
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        if (!containsJavaElements && containsNonJavaElements) {
            return Activator.imageDescriptorFromPlugin((String)"org.eclipse.handly.examples.jmodel.ui", (String)"icons/obj16/empty_pack_fldr_obj.gif");
        }
        if (!containsJavaElements) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.empty_pack_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.package_obj.gif");
    }

    private static ImageDescriptor getTypeImageDescriptor(boolean isInner, boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isEnum((int)flags)) {
            if (isInner) {
                return JavaElementImageProvider.getInnerEnumImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getEnumImageDescriptor(flags);
        }
        if (Flags.isAnnotation((int)flags)) {
            if (isInner) {
                return JavaElementImageProvider.getInnerAnnotationImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getAnnotationImageDescriptor(flags);
        }
        if (Flags.isInterface((int)flags)) {
            if (isInner) {
                return JavaElementImageProvider.getInnerInterfaceImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getInterfaceImageDescriptor(flags);
        }
        if (isInner) {
            return JavaElementImageProvider.getInnerClassImageDescriptor(isInInterfaceOrAnnotation, flags);
        }
        return JavaElementImageProvider.getClassImageDescriptor(flags);
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.class_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.class_default_obj.gif");
    }

    private static ImageDescriptor getInnerClassImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerclass_public_obj.gif");
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerclass_private_obj.gif");
        }
        if (Flags.isProtected((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerclass_protected_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerclass_default_obj.gif");
    }

    private static ImageDescriptor getInnerEnumImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.enum_obj.gif");
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.enum_private_obj.gif");
        }
        if (Flags.isProtected((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.enum_protected_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.enum_default_obj.gif");
    }

    private static ImageDescriptor getEnumImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.enum_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.enum_default_obj.gif");
    }

    private static ImageDescriptor getAnnotationImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.annotation_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.annotation_default_obj.gif");
    }

    private static ImageDescriptor getInnerAnnotationImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.annotation_obj.gif");
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.annotation_private_obj.gif");
        }
        if (Flags.isProtected((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.annotation_protected_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.annotation_default_obj.gif");
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.int_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.int_default_obj.gif");
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerinterface_public_obj.gif");
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerinterface_private_obj.gif");
        }
        if (Flags.isProtected((int)flags)) {
            return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.innerinterface_protected_obj.gif");
        }
        return JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.int_default_obj.gif");
    }

    private static boolean confirmAbstract(IMember element) throws CoreException {
        if (element instanceof IType) {
            return !((IType)element).isInterface();
        }
        return !element.getDeclaringType().isInterface();
    }

    private static boolean isEnumConstant(IMember element, int modifiers) {
        if (element instanceof IField) {
            return Flags.isEnum((int)modifiers);
        }
        return false;
    }

    private static boolean isInterfaceOrAnnotationField(IMember element) throws CoreException {
        if (element instanceof IField) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean isInterfaceOrAnnotationFieldOrType(IMember element) throws CoreException {
        if (element instanceof IField) {
            return element.getDeclaringType().isInterface();
        }
        if (element instanceof IType && element.getDeclaringType() != null) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }
}

