/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.examples.jmodel.IMethod;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.StyledString;

public class JavaElementLabelComposer {
    private final Object buffer;

    public static JavaElementLabelComposer create(StringBuilder sb) {
        Assert.isNotNull((Object)sb);
        return new JavaElementLabelComposer(sb);
    }

    public static JavaElementLabelComposer create(StyledString ss) {
        Assert.isNotNull((Object)ss);
        return new JavaElementLabelComposer(ss);
    }

    private JavaElementLabelComposer(Object buffer) {
        this.buffer = buffer;
    }

    public void appendElementLabel(IJavaElement element) throws CoreException {
        if (element instanceof IMethod) {
            this.appendMethodLabel((IMethod)element);
        } else if (element instanceof IPackageFragment) {
            this.appendPackageFragmentLabel((IPackageFragment)element);
        } else {
            this.append(element.getElementName());
        }
    }

    private void appendMethodLabel(IMethod method) throws CoreException {
        this.append(method.getElementName());
        this.append('(');
        String[] paramTypes = method.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                this.append(JavaElementLabels.COMMA_STRING);
            }
            String simpleName = this.getSimpleTypeName((IJavaElement)method, paramTypes[i]);
            this.append(simpleName);
            ++i;
        }
        this.append(')');
        String[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length > 0) {
            this.append(" throws ");
            int i2 = 0;
            while (i2 < exceptionTypes.length) {
                if (i2 > 0) {
                    this.append(JavaElementLabels.COMMA_STRING);
                }
                String simpleName = this.getSimpleTypeName((IJavaElement)method, exceptionTypes[i2]);
                this.append(simpleName);
                ++i2;
            }
        }
        if (!method.isConstructor()) {
            int offset = this.getLength();
            this.append(JavaElementLabels.DECL_STRING);
            this.appendTypeSignatureLabel((IJavaElement)method, method.getReturnType());
            this.setStyle(offset, this.getLength() - offset, StyledString.DECORATIONS_STYLER);
        }
    }

    private void appendPackageFragmentLabel(IPackageFragment pack) {
        if (pack.isDefaultPackage()) {
            this.append(JavaElementLabels.DEFAULT_PACKAGE);
        } else {
            this.append(pack.getElementName());
        }
    }

    private void appendTypeSignatureLabel(IJavaElement enclosingElement, String typeSig) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                this.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                this.appendTypeSignatureLabel(enclosingElement, Signature.getElementType((String)typeSig));
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    this.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = this.getSimpleTypeName(enclosingElement, typeSig);
                this.append(baseType);
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                this.appendTypeArgumentSignaturesLabel(enclosingElement, typeArguments);
                break;
            }
            case 3: {
                this.append(this.getSimpleTypeName(enclosingElement, typeSig));
                break;
            }
            case 5: {
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    this.append('?');
                    break;
                }
                if (ch == '+') {
                    this.append("? extends ");
                    this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1));
                    break;
                }
                if (ch != '-') break;
                this.append("? super ");
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1));
                break;
            }
            case 6: {
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1));
                break;
            }
            case 7: {
                String[] typeBounds = Signature.getIntersectionTypeBounds((String)typeSig);
                this.appendTypeBoundsSignaturesLabel(enclosingElement, typeBounds);
            }
        }
    }

    private void appendTypeArgumentSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig) {
        if (typeArgsSig.length > 0) {
            this.append("<");
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    this.append(JavaElementLabels.COMMA_STRING);
                }
                this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i]);
                ++i;
            }
            this.append(">");
        }
    }

    private void appendTypeBoundsSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig) {
        int i = 0;
        while (i < typeArgsSig.length) {
            if (i > 0) {
                this.append(" | ");
            }
            this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i]);
            ++i;
        }
    }

    private String getSimpleTypeName(IJavaElement enclosingElement, String typeSig) {
        return Signature.getSimpleName((String)Signature.toString((String)Signature.getTypeErasure((String)typeSig)));
    }

    private JavaElementLabelComposer append(char ch) {
        if (this.buffer instanceof StringBuilder) {
            ((StringBuilder)this.buffer).append(ch);
        } else {
            ((StyledString)this.buffer).append(ch);
        }
        return this;
    }

    private JavaElementLabelComposer append(String string) {
        if (string == null) {
            return this;
        }
        if (this.buffer instanceof StringBuilder) {
            ((StringBuilder)this.buffer).append(string);
        } else {
            ((StyledString)this.buffer).append(string);
        }
        return this;
    }

    private void setStyle(int offset, int length, StyledString.Styler styler) {
        if (this.buffer instanceof StyledString) {
            ((StyledString)this.buffer).setStyle(offset, length, styler);
        }
    }

    private int getLength() {
        if (this.buffer instanceof StringBuilder) {
            return ((StringBuilder)this.buffer).length();
        }
        return ((StyledString)this.buffer).length();
    }
}

