/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel.ui.navigator;

import org.eclipse.handly.examples.jmodel.JavaModelCore;
import org.eclipse.handly.internal.examples.jmodel.ui.Activator;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class JavaNavigator
extends CommonNavigator
implements IElementChangeListener {
    public static final String ID = "org.eclipse.handly.examples.jmodel.ui.views.JavaNavigator";
    private static final String STORE_SECTION = "JavaNavigator";
    private static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    private IDialogSettings settings;
    private IWorkingSet workingSet;
    private boolean emptyWorkingSet;
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            Object newValue = event.getNewValue();
            Object oldValue = event.getOldValue();
            if ("workingSetRemove".equals(property) && oldValue == JavaNavigator.this.workingSet) {
                JavaNavigator.this.setWorkingSet(null);
            } else if ("workingSetNameChange".equals(property) && newValue == JavaNavigator.this.workingSet) {
                JavaNavigator.this.updateTitle();
            } else if ("workingSetContentChange".equals(property) && newValue == JavaNavigator.this.workingSet) {
                if (JavaNavigator.this.workingSet.isAggregateWorkingSet() && JavaNavigator.this.workingSet.isEmpty()) {
                    if (!JavaNavigator.this.emptyWorkingSet) {
                        JavaNavigator.this.emptyWorkingSet = true;
                        JavaNavigator.this.workingSetFilter.setWorkingSet(null);
                    }
                } else if (JavaNavigator.this.emptyWorkingSet) {
                    JavaNavigator.this.emptyWorkingSet = false;
                    JavaNavigator.this.workingSetFilter.setWorkingSet(JavaNavigator.this.workingSet);
                }
                JavaNavigator.this.refresh();
            }
        }
    };

    public JavaNavigator() {
        IDialogSettings viewsSettings = Activator.getDefault().getDialogSettings();
        this.settings = viewsSettings.getSection(STORE_SECTION);
        if (this.settings == null) {
            this.settings = viewsSettings.addNewSection(STORE_SECTION);
        }
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        boolean refreshNeeded = this.internalSetWorkingSet(workingSet);
        this.workingSetFilter.setWorkingSet(this.emptyWorkingSet ? null : workingSet);
        if (workingSet != null) {
            this.settings.put(STORE_WORKING_SET, workingSet.getName());
        } else {
            this.settings.put(STORE_WORKING_SET, "");
        }
        this.updateTitle();
        if (refreshNeeded) {
            this.refresh();
        }
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer viewer = super.createCommonViewer(aParent);
        this.initWorkingSetFilter();
        viewer.addFilter((ViewerFilter)this.workingSetFilter);
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        workingSetManager.addPropertyChangeListener(this.workingSetListener);
        return viewer;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        JavaModelCore.getJavaModel().addElementChangeListener((IElementChangeListener)this);
    }

    public void dispose() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        workingSetManager.removePropertyChangeListener(this.workingSetListener);
        JavaModelCore.getJavaModel().removeElementChangeListener((IElementChangeListener)this);
        super.dispose();
    }

    public void elementChanged(IElementChangeEvent event) {
        final Control control = this.getCommonViewer().getControl();
        control.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!control.isDisposed()) {
                    JavaNavigator.this.refresh();
                }
            }
        });
    }

    protected Object getInitialInput() {
        return JavaModelCore.getJavaModel();
    }

    private void refresh() {
        Control control = this.getCommonViewer().getControl();
        control.setRedraw(false);
        BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                TreePath[] treePaths = JavaNavigator.this.getCommonViewer().getExpandedTreePaths();
                JavaNavigator.this.getCommonViewer().refresh();
                JavaNavigator.this.getCommonViewer().setExpandedTreePaths(treePaths);
            }
        });
        control.setRedraw(true);
    }

    private boolean internalSetWorkingSet(IWorkingSet workingSet) {
        boolean refreshNeeded = !Util.equals((Object)this.workingSet, (Object)workingSet);
        this.workingSet = workingSet;
        this.emptyWorkingSet = workingSet != null && workingSet.isAggregateWorkingSet() && workingSet.isEmpty();
        return refreshNeeded;
    }

    private void initWorkingSetFilter() {
        String workingSetName = this.settings.get(STORE_WORKING_SET);
        IWorkingSet workingSet = null;
        if (workingSetName != null && !workingSetName.isEmpty()) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            workingSet = workingSetManager.getWorkingSet(workingSetName);
        } else if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT")) {
            workingSet = this.getSite().getPage().getAggregateWorkingSet();
        }
        if (workingSet != null) {
            this.workingSetFilter.setWorkingSet(workingSet);
            this.internalSetWorkingSet(workingSet);
        }
    }
}

