/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.examples.jmodel;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.handly.examples.jmodel.IJavaModel;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;

public interface IJavaElement
extends IElement,
IAdaptable {
    default public String getElementName() {
        return Elements.getName((IElement)this);
    }

    default public IJavaElement getParent() {
        return (IJavaElement)Elements.getParent((IElement)this);
    }

    default public IJavaModel getJavaModel() {
        return (IJavaModel)Elements.getRoot((IElement)this);
    }

    default public <T extends IJavaElement> T getAncestorOfType(Class<T> type) {
        return (T)((IJavaElement)Elements.findAncestorOfType((IElement)this, type));
    }

    public String getHandleIdentifier();

    default public IResource getResource() {
        return Elements.getResource((IElement)this);
    }

    default public IPath getPath() {
        IResource resource = this.getResource();
        if (resource != null) {
            return resource.getFullPath();
        }
        throw new AssertionError((Object)"Please override the default implementation of this method");
    }

    default public boolean exists() {
        return Elements.exists((IElement)this);
    }

    default public IJavaElement[] getChildren() throws CoreException {
        return (IJavaElement[])Elements.getChildren((IElement)this);
    }

    default public <T extends IJavaElement> T[] getChildrenOfType(Class<T> type) throws CoreException {
        return (IJavaElement[])Elements.getChildrenOfType((IElement)this, type);
    }
}

