/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.jmodel.ICompilationUnit;
import org.eclipse.handly.examples.jmodel.IImportDeclaration;
import org.eclipse.handly.examples.jmodel.IJavaSourceConstruct;
import org.eclipse.handly.examples.jmodel.IJavaSourceElement;
import org.eclipse.handly.examples.jmodel.IPackageDeclaration;
import org.eclipse.handly.examples.jmodel.IType;
import org.eclipse.handly.internal.examples.jmodel.CompilatonUnitStructureBuilder;
import org.eclipse.handly.internal.examples.jmodel.ImportContainer;
import org.eclipse.handly.internal.examples.jmodel.ImportDeclaration;
import org.eclipse.handly.internal.examples.jmodel.JavaElement;
import org.eclipse.handly.internal.examples.jmodel.JavaProject;
import org.eclipse.handly.internal.examples.jmodel.JavaSourceConstruct;
import org.eclipse.handly.internal.examples.jmodel.MementoTokenizer;
import org.eclipse.handly.internal.examples.jmodel.PackageDeclaration;
import org.eclipse.handly.internal.examples.jmodel.PackageFragment;
import org.eclipse.handly.internal.examples.jmodel.Type;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.support.ISourceFileImplSupport;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;

public class CompilationUnit
extends JavaElement
implements ICompilationUnit,
ISourceFileImplSupport {
    static final IJavaSourceConstruct[] NO_CHILDREN = new IJavaSourceConstruct[0];
    private static final WorkingCopyOwner PRIMARY_OWNER = DefaultWorkingCopyOwner.PRIMARY;
    private static final IImportDeclaration[] NO_IMPORTS = new IImportDeclaration[0];
    private final IFile file;
    private final WorkingCopyOwner owner;
    private static final Property<AstHolder> AST_HOLDER = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".astHolder"), AstHolder.class);
    static final Property<Integer> AST_LEVEL = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".astLevel"), Integer.class).withDefault((Object)8);
    static final Property<Boolean> STRUCTURAL_AST = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".structuralAst"), Boolean.class).withDefault((Object)true);
    static final Property<Integer> FOCAL_POSITION = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".focalPosition"), Integer.class);
    static final Property<Boolean> RESOLVE_BINDINGS = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".resolveBindings"), Boolean.class).withDefault((Object)false);
    static final Property<Boolean> STATEMENTS_RECOVERY = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".statementsRecovery"), Boolean.class).withDefault((Object)false);
    static final Property<Boolean> BINDINGS_RECOVERY = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".bindingsRecovery"), Boolean.class).withDefault((Object)false);
    static final Property<Boolean> IGNORE_METHOD_BODIES = Property.get((String)(String.valueOf(CompilationUnit.class.getName()) + ".ignoreMethodBodies"), Boolean.class).withDefault((Object)false);

    public CompilationUnit(PackageFragment parent, IFile file, WorkingCopyOwner owner) {
        super(parent, file.getName());
        if (!file.getParent().equals((Object)parent.getResource())) {
            throw new IllegalArgumentException();
        }
        if (!"java".equals(file.getFileExtension())) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        if (owner == null) {
            owner = PRIMARY_OWNER;
        }
        this.owner = owner;
    }

    @Override
    public PackageFragment getParent() {
        return (PackageFragment)this.getParent_();
    }

    @Override
    public IFile getFile() {
        return this.getFile_();
    }

    @Override
    public ImportDeclaration getImport(String name) {
        return this.getImportContainer().getImport(name);
    }

    @Override
    public ImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    @Override
    public IImportDeclaration[] getImports() throws CoreException {
        ImportContainer container = this.getImportContainer();
        if (container.exists()) {
            return container.getImports();
        }
        return NO_IMPORTS;
    }

    @Override
    public PackageDeclaration getPackageDeclaration(String name) {
        return new PackageDeclaration(this, name);
    }

    @Override
    public IPackageDeclaration[] getPackageDeclarations() throws CoreException {
        return (IPackageDeclaration[])this.getChildrenOfType(IPackageDeclaration.class);
    }

    @Override
    public Type getType(String name) {
        return new Type(this, name);
    }

    @Override
    public IType[] getTypes() throws CoreException {
        return (IType[])this.getChildrenOfType(IType.class);
    }

    @Override
    public IJavaSourceElement getElementAt(int position, ISnapshot base) throws CoreException {
        return (IJavaSourceElement)this.getSourceElementAt_(position, Contexts.of((Property)Elements.BASE_SNAPSHOT, (Object)base), null);
    }

    @Override
    public boolean isWorkingCopy() {
        return this.isWorkingCopy_();
    }

    @Override
    public org.eclipse.jdt.core.dom.CompilationUnit reconcile(int astLevel, int reconcileFlags, IProgressMonitor monitor) throws CoreException {
        Context context = new Context();
        if (astLevel != 0) {
            context.bind(AST_HOLDER).to((Object)new AstHolder());
            context.bind(AST_LEVEL).to((Object)astLevel);
            context.bind(STRUCTURAL_AST).to((Object)false);
            context.bind(RESOLVE_BINDINGS).to((Object)true);
            context.bind(STATEMENTS_RECOVERY).to((Object)((reconcileFlags & 2) != 0 ? 1 : 0));
            context.bind(BINDINGS_RECOVERY).to((Object)((reconcileFlags & 4) != 0 ? 1 : 0));
            context.bind(IGNORE_METHOD_BODIES).to((Object)((reconcileFlags & 8) != 0 ? 1 : 0));
        }
        context.bind(Elements.FORCE_RECONCILING).to((Object)((reconcileFlags & 1) != 0 ? 1 : 0));
        this.reconcile_((IContext)context, monitor);
        if (astLevel != 0) {
            return ((AstHolder)context.get(CompilationUnit.AST_HOLDER)).ast;
        }
        return null;
    }

    @Override
    public IBuffer getBuffer() throws CoreException {
        return this.getBuffer_(Contexts.EMPTY_CONTEXT, null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompilationUnit)) {
            return false;
        }
        CompilationUnit other = (CompilationUnit)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    public IResource getResource_() {
        return this.file;
    }

    public IFile getFile_() {
        return this.file;
    }

    public void validateExistence_(IContext context) throws CoreException {
        super.validateExistence_(context);
        IStatus status = this.validateCompilationUnitName();
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    IStatus validateCompilationUnitName() {
        JavaProject javaProject = (JavaProject)this.getAncestorOfType(JavaProject.class);
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        return JavaConventions.validateCompilationUnitName((String)this.getElementName(), (String)sourceLevel, (String)complianceLevel);
    }

    org.eclipse.jdt.core.dom.CompilationUnit createAst(String source, IContext context, IProgressMonitor monitor) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)((Integer)context.getOrDefault(AST_LEVEL)));
        parser.setSource(source.toCharArray());
        parser.setUnitName(this.getPath().toString());
        parser.setProject(JavaCore.create((IProject)this.getResource().getProject()));
        if (context.containsKey(FOCAL_POSITION)) {
            parser.setFocalPosition(((Integer)context.get(FOCAL_POSITION)).intValue());
        } else if (((Boolean)context.getOrDefault(STRUCTURAL_AST)).booleanValue()) {
            parser.setFocalPosition(0);
        }
        parser.setResolveBindings(((Boolean)context.getOrDefault(RESOLVE_BINDINGS)).booleanValue());
        parser.setStatementsRecovery(((Boolean)context.getOrDefault(STATEMENTS_RECOVERY)).booleanValue());
        parser.setBindingsRecovery(((Boolean)context.getOrDefault(BINDINGS_RECOVERY)).booleanValue());
        parser.setIgnoreMethodBodies(((Boolean)context.getOrDefault(IGNORE_METHOD_BODIES)).booleanValue());
        return (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(monitor);
    }

    public void buildSourceStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
        org.eclipse.jdt.core.dom.CompilationUnit cu = (org.eclipse.jdt.core.dom.CompilationUnit)context.get(SOURCE_AST);
        if (cu == null) {
            cu = this.createAst((String)context.get(SOURCE_CONTENTS), context, monitor);
        }
        CompilatonUnitStructureBuilder builder = new CompilatonUnitStructureBuilder((Map)context.get(NEW_ELEMENTS));
        builder.buildStructure(this, cu);
    }

    public IContext newWorkingCopyContext_(IContext context) {
        return Contexts.with((IContext[])new IContext[]{(IContext)context.getOrDefault(WORKING_COPY_CONTEXT), Contexts.of(IProblemRequestor.class, (Object)((IProblemRequestor)context.get(IProblemRequestor.class)))});
    }

    public ISourceFileImplSupport.ReconcileOperation getReconcileOperation_() {
        return new CuReconcileOperation();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '{';
    }

    @Override
    protected JavaElement getHandleFromMemento(String token, MementoTokenizer memento) {
        if (token == MementoTokenizer.IMPORTDECLARATION) {
            return this.getImportContainer().getHandleFromMemento(memento);
        }
        if (token == MementoTokenizer.PACKAGEDECLARATION || token == MementoTokenizer.TYPE) {
            JavaSourceConstruct element;
            String name = "";
            String nextToken = null;
            if (memento.hasMoreTokens() && !MementoTokenizer.isDelimeter(nextToken = memento.nextToken())) {
                name = nextToken;
                nextToken = null;
            }
            if (token == MementoTokenizer.PACKAGEDECLARATION) {
                element = this.getPackageDeclaration(name);
            } else if (token == MementoTokenizer.TYPE) {
                element = this.getType(name);
            } else {
                throw new AssertionError();
            }
            if (nextToken == null) {
                return element.getHandleFromMemento(memento);
            }
            return ((JavaElement)element).getHandleFromMemento(token, memento);
        }
        return null;
    }

    private static class AstHolder {
        org.eclipse.jdt.core.dom.CompilationUnit ast;

        private AstHolder() {
        }
    }

    private class CuReconcileOperation
    extends ISourceFileImplSupport.NotifyingReconcileOperation {
        CuReconcileOperation() {
            super((ISourceFileImplSupport)CompilationUnit.this);
        }

        protected void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
            org.eclipse.jdt.core.dom.CompilationUnit cu = (org.eclipse.jdt.core.dom.CompilationUnit)context.get(SOURCE_AST);
            if (cu == null) {
                cu = CompilationUnit.this.createAst((String)context.get(SOURCE_CONTENTS), context, monitor);
                context = Contexts.with((IContext[])new IContext[]{Contexts.of((Property)SOURCE_AST, (Object)cu), context});
            }
            super.reconcile(context, monitor);
            this.reportProblems(cu.getProblems());
            AstHolder astHolder = (AstHolder)context.get(AST_HOLDER);
            if (astHolder != null) {
                astHolder.ast = cu;
            }
        }

        private void reportProblems(IProblem[] problems) {
            if (problems == null || problems.length == 0) {
                return;
            }
            this.reportProblems((IProblemRequestor)CompilationUnit.this.getWorkingCopyContext_().get(IProblemRequestor.class), problems);
        }

        private void reportProblems(IProblemRequestor requestor, IProblem[] problems) {
            if (requestor == null || !requestor.isActive()) {
                return;
            }
            try {
                requestor.beginReporting();
                IProblem[] iProblemArray = problems;
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    requestor.acceptProblem(problem);
                    ++n2;
                }
            }
            finally {
                requestor.endReporting();
            }
        }
    }
}

