/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.List;
import java.util.Map;
import org.eclipse.handly.examples.jmodel.IJavaSourceConstruct;
import org.eclipse.handly.internal.examples.jmodel.AstUtil;
import org.eclipse.handly.internal.examples.jmodel.CompilationUnit;
import org.eclipse.handly.internal.examples.jmodel.Field;
import org.eclipse.handly.internal.examples.jmodel.ImportContainer;
import org.eclipse.handly.internal.examples.jmodel.ImportDeclaration;
import org.eclipse.handly.internal.examples.jmodel.JavaElement;
import org.eclipse.handly.internal.examples.jmodel.Method;
import org.eclipse.handly.internal.examples.jmodel.PackageDeclaration;
import org.eclipse.handly.internal.examples.jmodel.Type;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.ISourceConstructImplExtension;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.model.impl.support.StructureHelper;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

class CompilatonUnitStructureBuilder {
    private static final IJavaSourceConstruct[] NO_CHILDREN = new IJavaSourceConstruct[0];
    private final Map<IElement, Object> newElements;
    private final StructureHelper helper = new StructureHelper();

    CompilatonUnitStructureBuilder(Map<IElement, Object> newElements) {
        if (newElements == null) {
            throw new IllegalArgumentException();
        }
        this.newElements = newElements;
    }

    void buildStructure(CompilationUnit handle, org.eclipse.jdt.core.dom.CompilationUnit cu) {
        List imports;
        SourceElementBody body = new SourceElementBody();
        org.eclipse.jdt.core.dom.PackageDeclaration pkg = cu.getPackage();
        if (pkg != null) {
            this.buildStructure(handle, (Object)body, pkg);
        }
        if (!(imports = cu.imports()).isEmpty()) {
            this.buildStructure(handle, (Object)body, imports);
        }
        List types = cu.types();
        for (AbstractTypeDeclaration type : types) {
            this.buildStructure((JavaElement)handle, (Object)body, type);
        }
        body.setChildren((IElement[])this.helper.popChildren((Object)body).toArray(CompilationUnit.NO_CHILDREN));
        this.newElements.put(handle, body);
    }

    private void buildStructure(CompilationUnit parent, Object parentBody, org.eclipse.jdt.core.dom.PackageDeclaration pkg) {
        PackageDeclaration handle = new PackageDeclaration(parent, pkg.getName().getFullyQualifiedName());
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)pkg));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)pkg.getName()));
        body.setChildren((IElement[])NO_CHILDREN);
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(CompilationUnit parent, Object parentBody, List<org.eclipse.jdt.core.dom.ImportDeclaration> imports) {
        ImportContainer handle = new ImportContainer(parent);
        SourceElementBody body = new SourceElementBody();
        org.eclipse.jdt.core.dom.ImportDeclaration firstImport = imports.get(0);
        org.eclipse.jdt.core.dom.ImportDeclaration lastImport = imports.get(imports.size() - 1);
        body.setFullRange(new TextRange(firstImport.getStartPosition(), lastImport.getStartPosition() + lastImport.getLength() - firstImport.getStartPosition()));
        for (org.eclipse.jdt.core.dom.ImportDeclaration importDecl : imports) {
            this.buildStructure(handle, (Object)body, importDecl);
        }
        body.setChildren((IElement[])this.helper.popChildren((Object)body).toArray(ImportContainer.NO_CHILDREN));
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(ImportContainer parent, Object parentBody, org.eclipse.jdt.core.dom.ImportDeclaration importDecl) {
        String name = importDecl.getName().getFullyQualifiedName();
        if (importDecl.isOnDemand()) {
            name = String.valueOf(name) + ".*";
        }
        ImportDeclaration handle = new ImportDeclaration(parent, name);
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)importDecl));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)importDecl.getName()));
        body.setChildren((IElement[])NO_CHILDREN);
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(JavaElement parent, Object parentBody, AbstractTypeDeclaration type) {
        Type handle = new Type(parent, type.getName().getIdentifier());
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)type));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)type.getName()));
        int flags = type.getModifiers();
        if (type instanceof TypeDeclaration) {
            org.eclipse.jdt.core.dom.Type superclassType;
            TypeDeclaration typeDeclaration = (TypeDeclaration)type;
            if (typeDeclaration.isInterface()) {
                flags |= 0x200;
            }
            if ((superclassType = typeDeclaration.getSuperclassType()) != null) {
                body.set(Type.SUPERCLASS_TYPE, (Object)AstUtil.getSignature(superclassType));
            }
            List superInterfaceTypes = typeDeclaration.superInterfaceTypes();
            body.set(Type.SUPER_INTERFACE_TYPES, (Object)AstUtil.getSignatures(superInterfaceTypes));
        } else if (type instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)type;
            flags |= 0x4000;
            List superInterfaceTypes = enumDeclaration.superInterfaceTypes();
            body.set(Type.SUPER_INTERFACE_TYPES, (Object)AstUtil.getSignatures(superInterfaceTypes));
            List enumConstants = enumDeclaration.enumConstants();
            for (EnumConstantDeclaration enumConstant : enumConstants) {
                this.buildStructure(handle, (Object)body, enumDeclaration, enumConstant);
            }
        } else if (type instanceof AnnotationTypeDeclaration) {
            flags |= 0x2200;
        }
        body.set(Type.FLAGS, (Object)flags);
        List bodyDeclarations = type.bodyDeclarations();
        for (BodyDeclaration bd : bodyDeclarations) {
            if (bd instanceof FieldDeclaration) {
                this.buildStructure(handle, (Object)body, (FieldDeclaration)bd);
                continue;
            }
            if (bd instanceof MethodDeclaration) {
                this.buildStructure(handle, (Object)body, (MethodDeclaration)bd);
                continue;
            }
            if (bd instanceof AbstractTypeDeclaration) {
                this.buildStructure((JavaElement)handle, (Object)body, (AbstractTypeDeclaration)bd);
                continue;
            }
            if (!(bd instanceof AnnotationTypeMemberDeclaration)) continue;
            this.buildStructure(handle, (Object)body, (AnnotationTypeMemberDeclaration)bd);
        }
        body.setChildren((IElement[])this.helper.popChildren((Object)body).toArray(Type.NO_CHILDREN));
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(Type parent, Object parentBody, FieldDeclaration field) {
        List fragments = field.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            this.buildStructure(parent, parentBody, field, fragment);
        }
    }

    private void buildStructure(Type parent, Object parentBody, FieldDeclaration field, VariableDeclarationFragment fragment) {
        Field handle = new Field(parent, fragment.getName().getIdentifier());
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)field));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)fragment.getName()));
        body.set(Field.FLAGS, (Object)field.getModifiers());
        body.set(Field.TYPE, (Object)Signature.createArraySignature((String)AstUtil.getSignature(field.getType()), (int)fragment.getExtraDimensions()));
        body.setChildren((IElement[])NO_CHILDREN);
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(Type parent, Object parentBody, EnumDeclaration enumDeclaration, EnumConstantDeclaration enumConstant) {
        Field handle = new Field(parent, enumConstant.getName().getIdentifier());
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)enumConstant));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)enumConstant.getName()));
        body.set(Field.FLAGS, (Object)(enumConstant.getModifiers() | 0x4000));
        body.set(Field.TYPE, (Object)Signature.createTypeSignature((String)enumDeclaration.getName().getIdentifier(), (boolean)false));
        body.setChildren((IElement[])NO_CHILDREN);
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(Type parent, Object parentBody, MethodDeclaration method) {
        List parameters = method.parameters();
        int numberOfParameters = parameters.size();
        String[] parameterTypes = new String[numberOfParameters];
        String[] parameterNames = new String[numberOfParameters];
        int i = 0;
        for (SingleVariableDeclaration parameter : parameters) {
            parameterTypes[i] = Signature.createArraySignature((String)AstUtil.getSignature(parameter.getType()), (int)parameter.getExtraDimensions());
            parameterNames[i] = parameter.getName().getIdentifier();
            ++i;
        }
        Method handle = new Method(parent, method.getName().getIdentifier(), parameterTypes);
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)method));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)method.getName()));
        body.set(Method.FLAGS, (Object)method.getModifiers());
        body.set(Method.PARAMETER_NAMES, (Object)parameterNames);
        org.eclipse.jdt.core.dom.Type returnType = method.getReturnType2();
        if (returnType != null) {
            body.set(Method.RETURN_TYPE, (Object)Signature.createArraySignature((String)AstUtil.getSignature(returnType), (int)method.getExtraDimensions()));
        }
        List thrownExceptions = method.thrownExceptionTypes();
        body.set(Method.EXCEPTION_TYPES, (Object)AstUtil.getSignatures(thrownExceptions));
        if (method.isConstructor()) {
            body.set(Method.IS_CONSTRUCTOR, (Object)Boolean.TRUE);
        }
        body.setChildren((IElement[])NO_CHILDREN);
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private void buildStructure(Type parent, Object parentBody, AnnotationTypeMemberDeclaration annotationTypeMember) {
        Method handle = new Method(parent, annotationTypeMember.getName().getIdentifier(), Method.NO_STRINGS);
        this.helper.resolveDuplicates((ISourceConstructImplExtension)handle);
        SourceElementBody body = new SourceElementBody();
        body.setFullRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)annotationTypeMember));
        body.setIdentifyingRange(CompilatonUnitStructureBuilder.getTextRange((ASTNode)annotationTypeMember.getName()));
        body.set(Method.FLAGS, (Object)annotationTypeMember.getModifiers());
        body.set(Method.RETURN_TYPE, (Object)AstUtil.getSignature(annotationTypeMember.getType()));
        body.setChildren((IElement[])NO_CHILDREN);
        this.newElements.put(handle, body);
        this.helper.pushChild(parentBody, (IElement)handle);
    }

    private static TextRange getTextRange(ASTNode node) {
        int startPosition = node.getStartPosition();
        if (startPosition == -1) {
            return null;
        }
        return new TextRange(startPosition, node.getLength());
    }
}

