/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.internal.examples.jmodel.JavaModelManager;
import org.eclipse.handly.internal.examples.jmodel.MementoTokenizer;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.Element;
import org.eclipse.handly.model.impl.support.IModelManager;

public abstract class JavaElement
extends Element
implements IJavaElement {
    static final char JEM_ESCAPE = '\\';
    static final char JEM_JAVAPROJECT = '=';
    static final char JEM_PACKAGEFRAGMENTROOT = '/';
    static final char JEM_PACKAGEFRAGMENT = '<';
    static final char JEM_COMPILATIONUNIT = '{';
    static final char JEM_COUNT = '!';
    static final char JEM_PACKAGEDECLARATION = '%';
    static final char JEM_IMPORTDECLARATION = '#';
    static final char JEM_TYPE = '[';
    static final char JEM_FIELD = '^';
    static final char JEM_METHOD = '~';

    public JavaElement(JavaElement parent, String name) {
        super((IElement)parent, name);
    }

    @Override
    public JavaElement getParent() {
        return (JavaElement)this.getParent_();
    }

    @Override
    public final String getHandleIdentifier() {
        return this.getHandleMemento_();
    }

    public final IModelManager getModelManager_() {
        return JavaModelManager.INSTANCE;
    }

    public final String getHandleMemento_() {
        StringBuilder sb = new StringBuilder();
        this.getHandleMemento(sb);
        return sb.toString();
    }

    protected void getHandleMemento(StringBuilder sb) {
        this.getParent().getHandleMemento(sb);
        sb.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(sb, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    protected final void escapeMementoName(StringBuilder sb, String name) {
        int i = 0;
        int length = name.length();
        while (i < length) {
            char character = name.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '%': 
                case '/': 
                case '<': 
                case '=': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '~': {
                    sb.append('\\');
                }
            }
            sb.append(character);
            ++i;
        }
    }

    public final JavaElement getHandleFromMemento(MementoTokenizer memento) {
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String token = memento.nextToken();
        return this.getHandleFromMemento(token, memento);
    }

    protected abstract JavaElement getHandleFromMemento(String var1, MementoTokenizer var2);
}

