/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.jmodel.IJavaModel;
import org.eclipse.handly.examples.jmodel.IJavaProject;
import org.eclipse.handly.internal.examples.jmodel.JavaElement;
import org.eclipse.handly.internal.examples.jmodel.JavaModelBody;
import org.eclipse.handly.internal.examples.jmodel.JavaModelManager;
import org.eclipse.handly.internal.examples.jmodel.JavaProject;
import org.eclipse.handly.internal.examples.jmodel.MementoTokenizer;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.impl.IModelImpl;

public class JavaModel
extends JavaElement
implements IJavaModel,
IModelImpl {
    private static final IJavaProject[] NO_CHILDREN = new IJavaProject[0];
    private final IWorkspace workspace;

    public JavaModel(IWorkspace workspace) {
        super(null, null);
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        this.workspace = workspace;
    }

    @Override
    public void addElementChangeListener(IElementChangeListener listener) {
        JavaModelManager.INSTANCE.getNotificationManager().addElementChangeListener(listener);
    }

    @Override
    public void removeElementChangeListener(IElementChangeListener listener) {
        JavaModelManager.INSTANCE.getNotificationManager().removeElementChangeListener(listener);
    }

    @Override
    public JavaProject getJavaProject(String name) {
        return new JavaProject(this, this.workspace.getRoot().getProject(name));
    }

    @Override
    public IJavaProject[] getJavaProjects() throws CoreException {
        return (IJavaProject[])this.getChildren();
    }

    @Override
    public IProject[] getNonJavaProjects() throws CoreException {
        return ((JavaModelBody)((Object)this.getBody_())).getNonJavaProjects(this);
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaModel other = (JavaModel)obj;
        return this.workspace.equals(other.workspace);
    }

    public int hashCode() {
        return this.workspace.hashCode();
    }

    public IContext getModelContext_() {
        return JavaModelManager.INSTANCE.getModelContext();
    }

    public int getModelApiLevel_() {
        return 0;
    }

    public IResource getResource_() {
        return this.workspace.getRoot();
    }

    public boolean exists_() {
        return true;
    }

    public void validateExistence_(IContext context) throws CoreException {
    }

    public void buildStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
        IProject[] projects = this.workspace.getRoot().getProjects();
        ArrayList<JavaProject> javaProjects = new ArrayList<JavaProject>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                javaProjects.add(new JavaProject(this, project));
            }
            ++n2;
        }
        JavaModelBody body = new JavaModelBody();
        body.setChildren(javaProjects.toArray(NO_CHILDREN));
        ((Map)context.get(NEW_ELEMENTS)).put(this, body);
    }

    public void toStringName_(StringBuilder builder, IContext context) {
        builder.append("Java Model");
    }

    @Override
    protected void getHandleMemento(StringBuilder sb) {
    }

    @Override
    protected char getHandleMementoDelimiter() {
        throw new AssertionError((Object)"This method should not be called");
    }

    @Override
    protected JavaElement getHandleFromMemento(String token, MementoTokenizer memento) {
        if (token == MementoTokenizer.JAVAPROJECT) {
            String projectName = "";
            token = null;
            if (memento.hasMoreTokens() && !MementoTokenizer.isDelimeter(token = memento.nextToken())) {
                projectName = token;
                token = null;
            }
            JavaProject project = this.getJavaProject(projectName);
            if (token == null) {
                return project.getHandleFromMemento(memento);
            }
            return project.getHandleFromMemento(token, memento);
        }
        return null;
    }
}

