/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.HashMap;
import org.eclipse.handly.examples.jmodel.ICompilationUnit;
import org.eclipse.handly.examples.jmodel.IJavaModel;
import org.eclipse.handly.examples.jmodel.IJavaProject;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.handly.examples.jmodel.IPackageFragmentRoot;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.Body;
import org.eclipse.handly.model.impl.support.ElementCache;
import org.eclipse.handly.model.impl.support.IBodyCache;

class JavaModelCache
implements IBodyCache {
    private static final int DEFAULT_PROJECT_SIZE = 5;
    private static final int DEFAULT_ROOT_SIZE = 50;
    private static final int DEFAULT_PKG_SIZE = 500;
    private static final int DEFAULT_FILE_SIZE = 250;
    private static final int DEFAULT_CHILDREN_SIZE = 5000;
    private final double memoryRatio = this.getMemoryRatio();
    private Object modelBody;
    private HashMap<IElement, Object> projectCache = new HashMap(5);
    private ElementCache rootCache = new ElementCache((int)(50.0 * this.memoryRatio));
    private ElementCache pkgCache = new ElementCache((int)(500.0 * this.memoryRatio));
    private ElementCache fileCache = new ElementCache((int)(250.0 * this.memoryRatio));
    private HashMap<IElement, Object> childrenCache = new HashMap((int)(5000.0 * this.memoryRatio));

    public Object get(IElement element) {
        if (element instanceof IJavaModel) {
            return this.modelBody;
        }
        if (element instanceof IJavaProject) {
            return this.projectCache.get(element);
        }
        if (element instanceof IPackageFragmentRoot) {
            return this.rootCache.get((Object)element);
        }
        if (element instanceof IPackageFragment) {
            return this.pkgCache.get((Object)element);
        }
        if (element instanceof ICompilationUnit) {
            return this.fileCache.get((Object)element);
        }
        return this.childrenCache.get(element);
    }

    public Object peek(IElement element) {
        if (element instanceof IJavaModel) {
            return this.modelBody;
        }
        if (element instanceof IJavaProject) {
            return this.projectCache.get(element);
        }
        if (element instanceof IPackageFragmentRoot) {
            return this.rootCache.peek((Object)element);
        }
        if (element instanceof IPackageFragment) {
            return this.pkgCache.peek((Object)element);
        }
        if (element instanceof ICompilationUnit) {
            return this.fileCache.peek((Object)element);
        }
        return this.childrenCache.get(element);
    }

    public void put(IElement element, Object body) {
        if (element instanceof IJavaModel) {
            this.modelBody = body;
        } else if (element instanceof IJavaProject) {
            this.projectCache.put(element, body);
            this.rootCache.ensureSpaceLimit(((Body)body).getChildren().length, element);
        } else if (element instanceof IPackageFragmentRoot) {
            this.rootCache.put((Object)element, body);
            this.pkgCache.ensureSpaceLimit(((Body)body).getChildren().length, element);
        } else if (element instanceof IPackageFragment) {
            this.pkgCache.put((Object)element, body);
            this.fileCache.ensureSpaceLimit(((Body)body).getChildren().length, element);
        } else if (element instanceof ICompilationUnit) {
            this.fileCache.put((Object)element, body);
        } else {
            this.childrenCache.put(element, body);
        }
    }

    public void remove(IElement element) {
        if (element instanceof IJavaModel) {
            this.modelBody = null;
        } else if (element instanceof IJavaProject) {
            this.projectCache.remove(element);
            this.rootCache.resetSpaceLimit((int)(50.0 * this.memoryRatio), element);
        } else if (element instanceof IPackageFragmentRoot) {
            this.rootCache.remove((Object)element);
            this.pkgCache.resetSpaceLimit((int)(500.0 * this.memoryRatio), element);
        } else if (element instanceof IPackageFragment) {
            this.pkgCache.remove((Object)element);
            this.fileCache.resetSpaceLimit((int)(250.0 * this.memoryRatio), element);
        } else if (element instanceof ICompilationUnit) {
            this.fileCache.remove((Object)element);
        } else {
            this.childrenCache.remove(element);
        }
    }

    private double getMemoryRatio() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        return maxMemory == Long.MAX_VALUE ? 4.0 : (double)maxMemory / 6.7108864E7;
    }
}

