/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.jmodel.IJavaElement;
import org.eclipse.handly.internal.examples.jmodel.Activator;
import org.eclipse.handly.internal.examples.jmodel.DeltaProcessingState;
import org.eclipse.handly.internal.examples.jmodel.DeltaProcessor;
import org.eclipse.handly.internal.examples.jmodel.JavaElementDelta;
import org.eclipse.handly.internal.examples.jmodel.JavaElementHandleFactory;
import org.eclipse.handly.internal.examples.jmodel.JavaModel;
import org.eclipse.handly.internal.examples.jmodel.JavaModelCache;
import org.eclipse.handly.internal.examples.jmodel.JavaProject;
import org.eclipse.handly.internal.examples.jmodel.PerProjectInfo;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.IElementHandleFactory;
import org.eclipse.handly.model.impl.support.ElementChangeEvent;
import org.eclipse.handly.model.impl.support.ElementDelta;
import org.eclipse.handly.model.impl.support.ElementManager;
import org.eclipse.handly.model.impl.support.IBodyCache;
import org.eclipse.handly.model.impl.support.IModelManager;
import org.eclipse.handly.model.impl.support.INotificationManager;
import org.eclipse.handly.model.impl.support.NotificationManager;
import org.eclipse.handly.util.SavedStateJob;

public class JavaModelManager
implements IModelManager,
IResourceChangeListener {
    public static final JavaModelManager INSTANCE = new JavaModelManager();
    private JavaModel javaModel;
    private ElementManager elementManager;
    private NotificationManager notificationManager;
    private DeltaProcessingState deltaState;
    private Context modelContext;
    private Map<IProject, PerProjectInfo> perProjectInfo = new HashMap<IProject, PerProjectInfo>(5);

    public void startup() throws Exception {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.javaModel = new JavaModel(workspace);
            this.elementManager = new ElementManager((IBodyCache)new JavaModelCache());
            this.notificationManager = new NotificationManager();
            this.deltaState = new DeltaProcessingState();
            this.deltaState.initialize();
            this.modelContext = new Context();
            this.modelContext.bind(INotificationManager.class).to((Object)this.notificationManager);
            this.modelContext.bind(ElementDelta.Factory.class).to(element -> new JavaElementDelta((IJavaElement)element));
            this.modelContext.bind(IElementHandleFactory.class).to((Object)new JavaElementHandleFactory());
            workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
            new SavedStateJob("org.eclipse.handly.examples.jmodel", (IResourceChangeListener)this).schedule();
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.modelContext = null;
        this.deltaState = null;
        this.notificationManager = null;
        this.elementManager = null;
        this.javaModel = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        DeltaProcessor deltaProcessor;
        block6: {
            deltaProcessor = new DeltaProcessor(this.deltaState);
            try {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)deltaProcessor);
                }
                catch (CoreException e) {
                    Activator.log(e.getStatus());
                    this.deltaState.reset();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.deltaState.reset();
                throw throwable;
            }
            this.deltaState.reset();
        }
        IElementDelta delta = deltaProcessor.getDelta();
        if (!ElementDeltas.isEmpty((IElementDelta)delta)) {
            this.getNotificationManager().fireElementChangeEvent((IElementChangeEvent)new ElementChangeEvent(1, delta));
        }
    }

    public JavaModel getModel() {
        if (this.javaModel == null) {
            throw new IllegalStateException();
        }
        return this.javaModel;
    }

    public ElementManager getElementManager() {
        if (this.elementManager == null) {
            throw new IllegalStateException();
        }
        return this.elementManager;
    }

    public NotificationManager getNotificationManager() {
        if (this.notificationManager == null) {
            throw new IllegalStateException();
        }
        return this.notificationManager;
    }

    public IContext getModelContext() {
        if (this.modelContext == null) {
            throw new IllegalStateException();
        }
        return this.modelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfo;
        synchronized (map) {
            PerProjectInfo info = this.perProjectInfo.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfo.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws CoreException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            new JavaProject(this.javaModel, project).validateExistence_(Contexts.EMPTY_CONTEXT);
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(IProject project) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfo;
        synchronized (map) {
            this.perProjectInfo.remove(project);
        }
    }

    private JavaModelManager() {
    }
}

