/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.NoSuchElementException;

public final class MementoTokenizer {
    static final String JAVAPROJECT = Character.toString('=');
    static final String PACKAGEFRAGMENTROOT = Character.toString('/');
    static final String PACKAGEFRAGMENT = Character.toString('<');
    static final String COMPILATIONUNIT = Character.toString('{');
    static final String COUNT = Character.toString('!');
    static final String PACKAGEDECLARATION = Character.toString('%');
    static final String IMPORTDECLARATION = Character.toString('#');
    static final String TYPE = Character.toString('[');
    static final String FIELD = Character.toString('^');
    static final String METHOD = Character.toString('~');
    private final char[] memento;
    private final int length;
    private int index = 0;

    static boolean isDelimeter(String token) {
        return token == JAVAPROJECT || token == PACKAGEFRAGMENTROOT || token == PACKAGEFRAGMENT || token == COMPILATIONUNIT || token == COUNT || token == PACKAGEDECLARATION || token == IMPORTDECLARATION || token == TYPE || token == FIELD || token == METHOD;
    }

    public MementoTokenizer(String memento) {
        this.memento = memento.toCharArray();
        this.length = this.memento.length;
    }

    boolean hasMoreTokens() {
        return this.index < this.length;
    }

    /*
     * Enabled aggressive block sorting
     */
    String nextToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        int start = this.index;
        StringBuilder sb = null;
        switch (this.memento[this.index++]) {
            case '\\': {
                sb = new StringBuilder();
                sb.append(this.memento[this.index]);
                start = ++this.index;
                break;
            }
            case '=': {
                return JAVAPROJECT;
            }
            case '/': {
                return PACKAGEFRAGMENTROOT;
            }
            case '<': {
                return PACKAGEFRAGMENT;
            }
            case '{': {
                return COMPILATIONUNIT;
            }
            case '!': {
                return COUNT;
            }
            case '%': {
                return PACKAGEDECLARATION;
            }
            case '#': {
                return IMPORTDECLARATION;
            }
            case '[': {
                return TYPE;
            }
            case '^': {
                return FIELD;
            }
            case '~': {
                return METHOD;
            }
        }
        block17: while (this.index < this.length) {
            switch (this.memento[this.index]) {
                case '\\': {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(this.memento, start, this.index - start);
                    start = ++this.index;
                    break;
                }
                case '!': 
                case '#': 
                case '%': 
                case '/': 
                case '<': 
                case '=': 
                case '[': 
                case '^': 
                case '{': 
                case '~': {
                    break block17;
                }
            }
            ++this.index;
        }
        if (sb != null) {
            sb.append(this.memento, start, this.index - start);
            return sb.toString();
        }
        return new String(this.memento, start, this.index - start);
    }
}

