/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.jmodel.ICompilationUnit;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.handly.internal.examples.jmodel.CompilationUnit;
import org.eclipse.handly.internal.examples.jmodel.JavaElement;
import org.eclipse.handly.internal.examples.jmodel.JavaProject;
import org.eclipse.handly.internal.examples.jmodel.MementoTokenizer;
import org.eclipse.handly.internal.examples.jmodel.PackageFragmentBody;
import org.eclipse.handly.internal.examples.jmodel.PackageFragmentRoot;
import org.eclipse.handly.util.IndentPolicy;
import org.eclipse.handly.util.ToStringOptions;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.Signature;

public class PackageFragment
extends JavaElement
implements IPackageFragment {
    private static final ICompilationUnit[] NO_CHILDREN = new ICompilationUnit[0];
    private final String[] simpleNames;

    public PackageFragment(PackageFragmentRoot parent, String name) {
        super(parent, name);
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.simpleNames = Signature.getSimpleNames((String)name);
    }

    PackageFragment(PackageFragmentRoot parent, String[] simpleNames) {
        super(parent, Signature.toQualifiedName((String[])simpleNames));
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.simpleNames = simpleNames;
    }

    @Override
    public PackageFragmentRoot getParent() {
        return (PackageFragmentRoot)this.getParent_();
    }

    @Override
    public CompilationUnit getCompilationUnit(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return new CompilationUnit(this, ((IContainer)this.getResource()).getFile((IPath)new Path(name)), null);
    }

    @Override
    public ICompilationUnit[] getCompilationUnits() throws CoreException {
        return (ICompilationUnit[])this.getChildren();
    }

    @Override
    public Object[] getNonJavaResources() throws CoreException {
        if (this.isDefaultPackage()) {
            return PackageFragmentBody.NO_NON_JAVA_RESOURCES;
        }
        return ((PackageFragmentBody)((Object)this.getBody_())).getNonJavaResources(this);
    }

    @Override
    public boolean isDefaultPackage() {
        return this.getElementName().isEmpty();
    }

    @Override
    public boolean hasSubpackages() throws CoreException {
        IPackageFragment[] packages = (IPackageFragment[])this.getParent().getChildrenOfType(IPackageFragment.class);
        int namesLength = this.simpleNames.length;
        IPackageFragment[] iPackageFragmentArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IPackageFragment pkg = iPackageFragmentArray[n2];
                String[] otherNames = ((PackageFragment)pkg).simpleNames;
                if (otherNames.length > namesLength) {
                    int i = 0;
                    while (i < namesLength) {
                        if (this.simpleNames[i].equals(otherNames[i])) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    boolean isValidPackageName() {
        JavaProject javaProject = this.getParent().getParent();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        String[] stringArray = this.simpleNames;
        int n = this.simpleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleName = stringArray[n2];
            if (JavaConventions.validateIdentifier((String)simpleName, (String)sourceLevel, (String)complianceLevel).getSeverity() == 4) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IResource getResource_() {
        if (this.simpleNames.length == 0) {
            return this.getParent().getResource();
        }
        Path path = Path.EMPTY;
        String[] stringArray = this.simpleNames;
        int n = this.simpleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String simpleName = stringArray[n2];
            path = path.append(simpleName);
            ++n2;
        }
        return ((IContainer)this.getParent().getResource()).getFolder((IPath)path);
    }

    public void validateExistence_(IContext context) throws CoreException {
        if (!this.isValidPackageName()) {
            throw this.newDoesNotExistException_();
        }
        IResource resource = this.getResource();
        if (resource != null && !resource.isAccessible()) {
            throw this.newDoesNotExistException_();
        }
    }

    public void buildStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
        HashSet<CompilationUnit> children = new HashSet<CompilationUnit>();
        IResource[] members = ((IContainer)this.getResource()).members();
        if (members.length > 0) {
            JavaProject javaProject = (JavaProject)this.getAncestorOfType(JavaProject.class);
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member instanceof IFile && JavaConventions.validateCompilationUnitName((String)member.getName(), (String)sourceLevel, (String)complianceLevel).getSeverity() != 4) {
                    children.add(new CompilationUnit(this, (IFile)member, null));
                }
                ++n2;
            }
        }
        PackageFragmentBody body = new PackageFragmentBody();
        body.setChildren(children.toArray(NO_CHILDREN));
        ((Map)context.get(NEW_ELEMENTS)).put(this, body);
    }

    public String toString_(IContext context) {
        if (context.getOrDefault(ToStringOptions.FORMAT_STYLE) == ToStringOptions.FormatStyle.LONG) {
            StringBuilder builder = new StringBuilder();
            IndentPolicy indentPolicy = (IndentPolicy)context.getOrDefault(ToStringOptions.INDENT_POLICY);
            int indentLevel = (Integer)context.getOrDefault(ToStringOptions.INDENT_LEVEL);
            indentPolicy.appendIndent(builder, indentLevel);
            Object body = this.peekAtBody_();
            this.toStringBody_(builder, body, context);
            if (body != null) {
                builder.append(" (...)");
            }
            return builder.toString();
        }
        return super.toString_(context);
    }

    public void toStringName_(StringBuilder builder, IContext context) {
        if (this.isDefaultPackage()) {
            builder.append("<default>");
        } else {
            super.toStringName_(builder, context);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '<';
    }

    @Override
    protected JavaElement getHandleFromMemento(String token, MementoTokenizer memento) {
        if (token == MementoTokenizer.COMPILATIONUNIT) {
            String name = "";
            token = null;
            if (memento.hasMoreTokens() && !MementoTokenizer.isDelimeter(token = memento.nextToken())) {
                name = token;
                token = null;
            }
            CompilationUnit compilationUnit = this.getCompilationUnit(name);
            if (token == null) {
                return compilationUnit.getHandleFromMemento(memento);
            }
            return compilationUnit.getHandleFromMemento(token, memento);
        }
        return null;
    }
}

