/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.jmodel.IPackageFragment;
import org.eclipse.handly.examples.jmodel.IPackageFragmentRoot;
import org.eclipse.handly.internal.examples.jmodel.ClasspathUtil;
import org.eclipse.handly.internal.examples.jmodel.JavaElement;
import org.eclipse.handly.internal.examples.jmodel.JavaProject;
import org.eclipse.handly.internal.examples.jmodel.MementoTokenizer;
import org.eclipse.handly.internal.examples.jmodel.PackageFragment;
import org.eclipse.handly.internal.examples.jmodel.PackageFragmentRootBody;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaConventions;

public class PackageFragmentRoot
extends JavaElement
implements IPackageFragmentRoot {
    private static final IPackageFragment[] NO_CHILDREN = new IPackageFragment[0];
    private final IResource resource;

    public PackageFragmentRoot(JavaProject parent, IResource resource) {
        super(parent, resource.getName());
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.resource = resource;
    }

    @Override
    public JavaProject getParent() {
        return (JavaProject)this.getParent_();
    }

    @Override
    public PackageFragment getPackageFragment(String packageName) {
        return new PackageFragment(this, packageName);
    }

    PackageFragment getPackageFragment(String[] simpleNames) {
        return new PackageFragment(this, simpleNames);
    }

    @Override
    public IPackageFragment[] getPackageFragments() throws CoreException {
        return (IPackageFragment[])this.getChildren();
    }

    @Override
    public Object[] getNonJavaResources() throws CoreException {
        return ((PackageFragmentRootBody)((Object)this.getBody_())).getNonJavaResources(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.resource.equals((Object)other.resource) && this.getParent().equals(other.getParent());
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public IResource getResource_() {
        return this.resource;
    }

    public void validateExistence_(IContext context) throws CoreException {
        this.validateOnClasspath();
        if (!this.resource.isAccessible()) {
            throw this.newDoesNotExistException_();
        }
    }

    protected void validateOnClasspath() throws CoreException {
        IClasspathEntry[] rawClasspath = this.getParent().getRawClasspath();
        if (!ClasspathUtil.isSourceFolder(this.resource, rawClasspath)) {
            throw this.newDoesNotExistException_();
        }
    }

    public void buildStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
        PackageFragmentRootBody body = new PackageFragmentRootBody();
        ArrayList<IPackageFragment> children = new ArrayList<IPackageFragment>();
        if (this.resource.getType() == 2 || this.resource.getType() == 4) {
            IContainer rootFolder = (IContainer)this.resource;
            this.computeFolderChildren(rootFolder, (IPath)Path.EMPTY, children);
        }
        body.setChildren(children.toArray(NO_CHILDREN));
        ((Map)context.get(NEW_ELEMENTS)).put(this, body);
    }

    private void computeFolderChildren(IContainer folder, IPath packagePath, ArrayList<IPackageFragment> children) throws CoreException {
        children.add(new PackageFragment(this, packagePath.segments()));
        IResource[] members = folder.members();
        if (members.length > 0) {
            JavaProject javaProject = this.getParent();
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String memberName;
                IResource member = iResourceArray[n2];
                if (member instanceof IFolder && JavaConventions.validateIdentifier((String)(memberName = member.getName()), (String)sourceLevel, (String)complianceLevel).getSeverity() != 4) {
                    this.computeFolderChildren((IContainer)((IFolder)member), packagePath.append(memberName), children);
                }
                ++n2;
            }
        }
    }

    @Override
    protected void getHandleMemento(StringBuilder sb) {
        this.getParent().getHandleMemento(sb);
        sb.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(sb, this.resource.getProjectRelativePath().toString());
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    protected JavaElement getHandleFromMemento(String token, MementoTokenizer memento) {
        if (token == MementoTokenizer.PACKAGEFRAGMENT) {
            String packageName = "";
            token = null;
            if (memento.hasMoreTokens() && !MementoTokenizer.isDelimeter(token = memento.nextToken())) {
                packageName = token;
                token = null;
            }
            PackageFragment packageFragment = this.getPackageFragment(packageName);
            if (token == null) {
                return packageFragment.getHandleFromMemento(memento);
            }
            return packageFragment.getHandleFromMemento(token, memento);
        }
        return null;
    }
}

