/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class PerProjectInfo {
    private final IProject project;
    private volatile IClasspathEntry[] rawClasspath;
    private volatile IPath outputLocation;

    PerProjectInfo(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public IClasspathEntry[] getRawClasspath() {
        IClasspathEntry[] rawClasspath = this.rawClasspath;
        if (rawClasspath == null) {
            this.rawClasspath = rawClasspath = JavaCore.create((IProject)this.project).readRawClasspath();
        }
        return rawClasspath;
    }

    public IPath getOutputLocation() {
        IPath outputLocation = this.outputLocation;
        if (outputLocation == null) {
            outputLocation = JavaCore.create((IProject)this.project).readOutputLocation();
            if (outputLocation == null) {
                outputLocation = this.project.getFullPath().append("bin");
            }
            this.outputLocation = outputLocation;
        }
        return outputLocation;
    }

    void setRawClasspath(IClasspathEntry[] rawClasspath, IPath outputLocation) {
        this.rawClasspath = rawClasspath;
        this.outputLocation = outputLocation;
    }
}

