/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.internal.examples.jmodel;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.examples.jmodel.IField;
import org.eclipse.handly.examples.jmodel.IMember;
import org.eclipse.handly.examples.jmodel.IMethod;
import org.eclipse.handly.examples.jmodel.IType;
import org.eclipse.handly.internal.examples.jmodel.Field;
import org.eclipse.handly.internal.examples.jmodel.JavaElement;
import org.eclipse.handly.internal.examples.jmodel.Member;
import org.eclipse.handly.internal.examples.jmodel.MementoTokenizer;
import org.eclipse.handly.internal.examples.jmodel.Method;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.support.ISourceElementImplSupport;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jdt.core.Flags;

public class Type
extends Member
implements IType {
    static final IMember[] NO_CHILDREN = new IMember[0];

    public Type(JavaElement parent, String name) {
        super(parent, name);
        if (name == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Field getField(String name) {
        return new Field(this, name);
    }

    @Override
    public IField[] getFields() throws CoreException {
        return (IField[])this.getChildrenOfType(IField.class);
    }

    @Override
    public Method getMethod(String name, String[] parameterTypes) {
        return new Method(this, name, parameterTypes);
    }

    @Override
    public IMethod[] getMethods() throws CoreException {
        return (IMethod[])this.getChildrenOfType(IMethod.class);
    }

    @Override
    public Type getType(String name) {
        return new Type(this, name);
    }

    @Override
    public IType[] getTypes() throws CoreException {
        return (IType[])this.getChildrenOfType(IType.class);
    }

    @Override
    public String getSuperclassType() throws CoreException {
        return (String)this.getSourceElementInfo().get(SUPERCLASS_TYPE);
    }

    @Override
    public String[] getSuperInterfaceTypes() throws CoreException {
        String[] result = (String[])this.getSourceElementInfo().get(SUPER_INTERFACE_TYPES);
        if (result == null) {
            return NO_STRINGS;
        }
        return result;
    }

    @Override
    public boolean isClass() throws CoreException {
        int flags = this.getFlags();
        return !Flags.isEnum((int)flags) && !Flags.isInterface((int)flags) && !Flags.isAnnotation((int)flags);
    }

    @Override
    public boolean isEnum() throws CoreException {
        return Flags.isEnum((int)this.getFlags());
    }

    @Override
    public boolean isInterface() throws CoreException {
        return Flags.isInterface((int)this.getFlags());
    }

    @Override
    public boolean isAnnotation() throws CoreException {
        int flags = this.getFlags();
        return Flags.isInterface((int)flags) && Flags.isAnnotation((int)flags);
    }

    @Override
    public boolean isMember() {
        return this.getDeclaringType() != null;
    }

    public ISourceElement getSourceElementAt_(int position, ISourceElementInfo info, IContext context, IProgressMonitor monitor) throws CoreException {
        ISnapshot snapshot;
        if (context.get(Elements.BASE_SNAPSHOT) == null && (snapshot = info.getSnapshot()) != null) {
            context = Contexts.with((IContext[])new IContext[]{Contexts.of((Property)Elements.BASE_SNAPSHOT, (Object)snapshot), context});
        }
        ISourceConstruct[] children = info.getChildren();
        monitor.beginTask("", children.length);
        try {
            int i = children.length - 1;
            while (i >= 0) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ISourceConstruct child = children[i];
                if (child instanceof IField) {
                    ISourceElementInfo childInfo = Elements.getSourceElementInfo((ISourceElement)child);
                    if (ISourceElementImplSupport.checkInRange((int)position, (ISourceElementInfo)childInfo, (IContext)context)) {
                        ISourceConstruct candidate = null;
                        do {
                            TextRange nameRange;
                            if ((nameRange = childInfo.getIdentifyingRange()) == null || position > nameRange.getEndOffset()) {
                                ISourceConstruct iSourceConstruct = candidate == null ? child : candidate;
                                return iSourceConstruct;
                            }
                            candidate = child;
                            if (--i < 0) {
                                child = null;
                                continue;
                            }
                            child = children[i];
                            childInfo = Elements.getSourceElementInfo((ISourceElement)child);
                        } while (child != null && ISourceElementImplSupport.checkInRange((int)position, (ISourceElementInfo)childInfo, (IContext)context));
                        ISourceConstruct iSourceConstruct = candidate;
                        return iSourceConstruct;
                    }
                } else {
                    ISourceElement found = Elements.getSourceElementAt((ISourceElement)child, (int)position, (IContext)context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (found != null) {
                        ISourceElement iSourceElement = found;
                        return iSourceElement;
                    }
                }
                --i;
            }
            Type type = this;
            return type;
        }
        finally {
            monitor.done();
        }
    }

    public void toStringBody_(StringBuilder builder, Object body, IContext context) {
        if (body != null && body != NO_BODY) {
            SourceElementBody typeBody = (SourceElementBody)body;
            int flags = (Integer)typeBody.get(FLAGS);
            if (Flags.isEnum((int)flags)) {
                builder.append("enum ");
            } else if (Flags.isAnnotation((int)flags)) {
                builder.append("@interface ");
            } else if (Flags.isInterface((int)flags)) {
                builder.append("interface ");
            } else {
                builder.append("class ");
            }
        }
        this.toStringName_(builder, context);
        if (body == null) {
            builder.append(" (not open)");
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '[';
    }

    @Override
    protected JavaElement getHandleFromMemento(String token, MementoTokenizer memento) {
        if (token == MementoTokenizer.COUNT) {
            return this.getHandleUpdatingCountFromMemento(memento);
        }
        if (token == MementoTokenizer.TYPE || token == MementoTokenizer.FIELD || token == MementoTokenizer.METHOD) {
            Member element;
            String name = "";
            String nextToken = null;
            if (memento.hasMoreTokens() && !MementoTokenizer.isDelimeter(nextToken = memento.nextToken())) {
                name = nextToken;
                nextToken = null;
            }
            if (token == MementoTokenizer.TYPE) {
                element = this.getType(name);
            } else if (token == MementoTokenizer.FIELD) {
                element = this.getField(name);
            } else if (token == MementoTokenizer.METHOD) {
                ArrayList<String> parameterTypes = new ArrayList<String>();
                while (memento.hasMoreTokens()) {
                    if (nextToken == null) {
                        nextToken = memento.nextToken();
                    }
                    if (nextToken != MementoTokenizer.METHOD) break;
                    nextToken = null;
                    if (!memento.hasMoreTokens()) continue;
                    nextToken = memento.nextToken();
                    if (MementoTokenizer.isDelimeter(nextToken)) break;
                    parameterTypes.add(nextToken);
                    nextToken = null;
                }
                element = this.getMethod(name, parameterTypes.toArray(new String[0]));
            } else {
                throw new AssertionError();
            }
            if (nextToken == null) {
                return element.getHandleFromMemento(memento);
            }
            return ((JavaElement)element).getHandleFromMemento(token, memento);
        }
        return null;
    }
}

