/*******************************************************************************
 * Copyright (c) 2017 1C-Soft LLC.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Vladimir Piskarev (1C) - initial API and implementation
 *******************************************************************************/
package org.eclipse.handly.model;

import org.eclipse.core.resources.IResource;

/**
 * Provides a generic way to create model element handles. A default instance
 * of the element handle factory for a model can usually be obtained via the
 * model's {@link Models#getModelContext(IModel) context} by <code>
 * context.get(IElementHandleFactory.class)</code>.
 * <p>
 * Note that despite having a dependency on {@link IResource} this interface can
 * safely be used even when <code>org.eclipse.core.resources</code> bundle is not
 * available. This is based on the "outward impression" of late resolution of
 * symbolic references a JVM must provide according to the JVMS.
 * </p>
 */
public interface IElementHandleFactory
{
    /**
     * Returns the model element handle created from the given handle memento
     * that was generated by {@link Elements#getHandleMemento(IElement)}.
     *
     * @param memento a handle memento (may be <code>null</code>)
     * @return the model element handle created from the given memento,
     *  or <code>null</code> if unable to create a model element handle
     *  from the given memento
     */
    IElement createFromHandleMemento(String memento);

    /**
     * Returns the handle of the model element corresponding to the given
     * workspace resource.
     *
     * @param resource a workspace resource handle (may be <code>null</code>)
     * @return the handle of the model element corresponding to the given
     *  resource, or <code>null</code> if unable to associate the given
     *  resource with a model element
     */
    IElement createFromResourceHandle(IResource resource);
}
