/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementHandleFactory;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.impl.support.Element;
import org.eclipse.handly.model.impl.support.SimpleElement;
import org.eclipse.handly.model.impl.support.SimpleModel;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;

public class ElementsTest
extends TestCase {
    private final SimpleModelManager manager = new SimpleModelManager();
    private final SimpleElement root = new SimpleElement(null, "root", this.manager);
    private final SimpleSourceFile aFile = new SimpleSourceFile((IElement)this.root, "aFile", null, this.manager);
    private final SimpleElement foo = new SimpleElement((IElement)this.aFile, "foo", this.manager);

    public void testGetName() {
        ElementsTest.assertEquals((String)"root", (String)Elements.getName((IElement)this.root));
        ElementsTest.assertEquals((String)"aFile", (String)Elements.getName((IElement)this.aFile));
        ElementsTest.assertEquals((String)"foo", (String)Elements.getName((IElement)this.foo));
    }

    public void testGetParent() {
        ElementsTest.assertNull((Object)Elements.getParent((IElement)this.root));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.getParent((IElement)this.aFile));
        ElementsTest.assertEquals((Object)((Object)this.aFile), (Object)Elements.getParent((IElement)this.foo));
    }

    public void testGetRoot() {
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.getRoot((IElement)this.root));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.getRoot((IElement)this.aFile));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.getRoot((IElement)this.foo));
    }

    public void testStreamParentChain() {
        ElementsTest.assertEquals(Collections.emptyList(), Elements.streamParentChain(null).collect(Collectors.toList()));
        ElementsTest.assertEquals(Collections.singletonList(this.root), Elements.streamParentChain((IElement)this.root).collect(Collectors.toList()));
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.aFile, this.root}), Elements.streamParentChain((IElement)this.aFile).collect(Collectors.toList()));
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.foo, this.aFile, this.root}), Elements.streamParentChain((IElement)this.foo).collect(Collectors.toList()));
    }

    public void testStreamParentChainUntil() {
        Predicate eqRoot = Predicate.isEqual((Object)this.root);
        ElementsTest.assertEquals(Collections.emptyList(), Elements.streamParentChainUntil(null, eqRoot).collect(Collectors.toList()));
        ElementsTest.assertEquals(Collections.emptyList(), Elements.streamParentChainUntil((IElement)this.root, eqRoot).collect(Collectors.toList()));
        ElementsTest.assertEquals(Arrays.asList(this.aFile), Elements.streamParentChainUntil((IElement)this.aFile, eqRoot).collect(Collectors.toList()));
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.foo, this.aFile}), Elements.streamParentChainUntil((IElement)this.foo, eqRoot).collect(Collectors.toList()));
    }

    public void testCollectParentChain() {
        ElementsTest.assertEquals(Collections.emptyList(), (Object)Elements.collectParentChain(null, new ArrayList()));
        ElementsTest.assertEquals(Collections.singletonList(this.root), (Object)Elements.collectParentChain((IElement)this.root, new ArrayList()));
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.aFile, this.root}), (Object)Elements.collectParentChain((IElement)this.aFile, new ArrayList()));
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.foo, this.aFile, this.root}), (Object)Elements.collectParentChain((IElement)this.foo, new ArrayList()));
    }

    public void testCollectParentChainUntil() {
        Predicate eqRoot = Predicate.isEqual((Object)this.root);
        ElementsTest.assertEquals(Collections.emptyList(), (Object)Elements.collectParentChainUntil(null, new ArrayList(), eqRoot));
        ElementsTest.assertEquals(Collections.emptyList(), (Object)Elements.collectParentChainUntil((IElement)this.root, new ArrayList(), eqRoot));
        ElementsTest.assertEquals(Arrays.asList(this.aFile), (Object)Elements.collectParentChainUntil((IElement)this.aFile, new ArrayList(), eqRoot));
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.foo, this.aFile}), (Object)Elements.collectParentChainUntil((IElement)this.foo, new ArrayList(), eqRoot));
    }

    public void testFindAncestorOfType() {
        ElementsTest.assertNull((Object)Elements.findAncestorOfType(null, SimpleElement.class));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findAncestorOfType((IElement)this.root, SimpleElement.class));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findAncestorOfType((IElement)this.aFile, SimpleElement.class));
        ElementsTest.assertEquals((Object)((Object)this.foo), (Object)Elements.findAncestorOfType((IElement)this.foo, SimpleElement.class));
    }

    public void testFindAncestorOfTypeUntil() {
        Predicate eqRoot = Predicate.isEqual((Object)this.root);
        ElementsTest.assertNull((Object)Elements.findAncestorOfTypeUntil(null, SimpleElement.class, eqRoot));
        ElementsTest.assertNull((Object)Elements.findAncestorOfTypeUntil((IElement)this.root, SimpleElement.class, eqRoot));
        ElementsTest.assertNull((Object)Elements.findAncestorOfTypeUntil((IElement)this.aFile, SimpleElement.class, eqRoot));
        ElementsTest.assertEquals((Object)((Object)this.foo), (Object)Elements.findAncestorOfTypeUntil((IElement)this.foo, SimpleElement.class, eqRoot));
    }

    public void testFindLastAncestorOfType() {
        ElementsTest.assertNull((Object)Elements.findLastAncestorOfType(null, SimpleElement.class));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findLastAncestorOfType((IElement)this.root, SimpleElement.class));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findLastAncestorOfType((IElement)this.aFile, SimpleElement.class));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findLastAncestorOfType((IElement)this.foo, SimpleElement.class));
    }

    public void testFindLastAncestorOfTypeUntil() {
        Predicate eqRoot = Predicate.isEqual((Object)this.root);
        ElementsTest.assertNull((Object)Elements.findLastAncestorOfTypeUntil(null, SimpleElement.class, eqRoot));
        ElementsTest.assertNull((Object)Elements.findLastAncestorOfTypeUntil((IElement)this.root, SimpleElement.class, eqRoot));
        ElementsTest.assertNull((Object)Elements.findLastAncestorOfTypeUntil((IElement)this.aFile, SimpleElement.class, eqRoot));
        ElementsTest.assertEquals((Object)((Object)this.foo), (Object)Elements.findLastAncestorOfTypeUntil((IElement)this.foo, SimpleElement.class, eqRoot));
    }

    public void testFindCommonAncestor() {
        SimpleElement bar = new SimpleElement((IElement)this.aFile, "bar", this.manager);
        SimpleElement baz = bar.getChild("baz");
        ElementsTest.assertNull((Object)Elements.findCommonAncestor(null, (IElement)this.root));
        ElementsTest.assertNull((Object)Elements.findCommonAncestor((IElement)this.root, null));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestor((IElement)this.root, (IElement)this.root));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestor((IElement)this.root, (IElement)this.aFile));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestor((IElement)this.root, (IElement)this.foo));
        ElementsTest.assertEquals((Object)((Object)this.aFile), (Object)Elements.findCommonAncestor((IElement)this.aFile, (IElement)this.foo));
        ElementsTest.assertEquals((Object)((Object)this.aFile), (Object)Elements.findCommonAncestor((IElement)this.foo, (IElement)bar));
        ElementsTest.assertEquals((Object)((Object)this.aFile), (Object)Elements.findCommonAncestor((IElement)this.foo, (IElement)baz));
        ElementsTest.assertEquals((Object)((Object)bar), (Object)Elements.findCommonAncestor((IElement)bar, (IElement)baz));
    }

    public void testFindCommonAncestorUntil() {
        SimpleElement bar = new SimpleElement((IElement)this.aFile, "bar", this.manager);
        SimpleElement baz = bar.getChild("baz");
        Predicate eqAFile = Predicate.isEqual((Object)this.aFile);
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil(null, (IElement)this.root, eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil((IElement)this.root, null, eqAFile));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestorUntil((IElement)this.root, (IElement)this.root, eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil((IElement)this.root, (IElement)this.aFile, eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil((IElement)this.root, (IElement)this.foo, eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil((IElement)this.aFile, (IElement)this.foo, eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil((IElement)this.foo, (IElement)bar, eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil((IElement)this.foo, (IElement)baz, eqAFile));
        ElementsTest.assertEquals((Object)((Object)bar), (Object)Elements.findCommonAncestorUntil((IElement)bar, (IElement)baz, eqAFile));
    }

    public void testFindCommonAncestor2() {
        SimpleElement bar = new SimpleElement((IElement)this.aFile, "bar", this.manager);
        SimpleElement baz = bar.getChild("baz");
        ElementsTest.assertNull((Object)Elements.findCommonAncestor(Collections.emptySet()));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestor(Collections.singleton(this.root)));
        ElementsTest.assertNull((Object)Elements.findCommonAncestor(Arrays.asList(null, this.root)));
        ElementsTest.assertNull((Object)Elements.findCommonAncestor(Arrays.asList(this.root, null)));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestor(Arrays.asList(this.root, this.root)));
        ElementsTest.assertEquals((Object)((Object)this.aFile), (Object)Elements.findCommonAncestor(Arrays.asList(this.foo, bar)));
        ElementsTest.assertEquals((Object)((Object)this.aFile), (Object)Elements.findCommonAncestor(Arrays.asList(this.foo, bar, baz)));
    }

    public void testFindCommonAncestorUntil2() {
        SimpleElement bar = new SimpleElement((IElement)this.aFile, "bar", this.manager);
        SimpleElement baz = bar.getChild("baz");
        Predicate eqAFile = Predicate.isEqual((Object)this.aFile);
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil(Collections.emptySet(), eqAFile));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestorUntil(Collections.singleton(this.root), eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil(Arrays.asList(null, this.root), eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil(Arrays.asList(this.root, null), eqAFile));
        ElementsTest.assertEquals((Object)((Object)this.root), (Object)Elements.findCommonAncestorUntil(Arrays.asList(this.root, this.root), eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil(Arrays.asList(this.foo, bar), eqAFile));
        ElementsTest.assertNull((Object)Elements.findCommonAncestorUntil(Arrays.asList(this.foo, bar, baz), eqAFile));
        ElementsTest.assertEquals((Object)((Object)bar), (Object)Elements.findCommonAncestorUntil(Arrays.asList(baz, bar.getChild("a"), baz.getChild("b")), eqAFile));
    }

    public void testIsAncestorOf() {
        ElementsTest.assertFalse((boolean)Elements.isAncestorOf((IElement)this.root, null));
        ElementsTest.assertTrue((boolean)Elements.isAncestorOf((IElement)this.root, (IElement)this.root));
        ElementsTest.assertTrue((boolean)Elements.isAncestorOf((IElement)this.root, (IElement)this.aFile));
        ElementsTest.assertFalse((boolean)Elements.isAncestorOf((IElement)this.aFile, (IElement)this.root));
        ElementsTest.assertTrue((boolean)Elements.isAncestorOf((IElement)this.root, (IElement)this.foo));
        ElementsTest.assertFalse((boolean)Elements.isAncestorOf((IElement)this.foo, (IElement)this.root));
        ElementsTest.assertTrue((boolean)Elements.isAncestorOf((IElement)this.aFile, (IElement)this.aFile));
        ElementsTest.assertTrue((boolean)Elements.isAncestorOf((IElement)this.aFile, (IElement)this.foo));
        ElementsTest.assertFalse((boolean)Elements.isAncestorOf((IElement)this.foo, (IElement)this.aFile));
        ElementsTest.assertTrue((boolean)Elements.isAncestorOf((IElement)this.foo, (IElement)this.foo));
    }

    public void testRemoveDescendants() {
        SimpleElement bar = new SimpleElement((IElement)this.aFile, "bar", this.manager);
        SimpleElement baz = bar.getChild("baz");
        ArrayList<Object> elements = new ArrayList<Object>();
        Elements.removeDescendants(elements);
        ElementsTest.assertTrue((boolean)elements.isEmpty());
        elements.add((Object)this.root);
        elements.add((Object)this.root);
        Elements.removeDescendants(elements);
        ElementsTest.assertEquals(Arrays.asList(this.root, this.root), elements);
        elements.clear();
        elements.add((Object)this.root);
        elements.add((Object)this.aFile);
        elements.add((Object)this.aFile);
        elements.add((Object)this.foo);
        Elements.removeDescendants(elements);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        elements.clear();
        elements.add((Object)this.aFile);
        elements.add((Object)this.foo);
        Elements.removeDescendants(elements);
        ElementsTest.assertEquals(Collections.singletonList(this.aFile), elements);
        elements.clear();
        elements.add((Object)bar);
        elements.add((Object)baz);
        elements.add((Object)this.foo);
        Elements.removeDescendants(elements);
        ElementsTest.assertEquals(Arrays.asList(bar, this.foo), elements);
    }

    public void testIsOfModel() {
        ElementsTest.assertTrue((boolean)Elements.isOfModel((IElement)this.root, (IModel)this.manager.getModel()));
        ElementsTest.assertFalse((boolean)Elements.isOfModel((IElement)this.root, (IModel)new SimpleModel()));
    }

    public void testSplitIntoElementsAndResources() {
        ArrayList elements = new ArrayList();
        Elements.splitIntoElementsAndResources(Collections.emptySet(), elements, null, null, null);
        ElementsTest.assertTrue((boolean)elements.isEmpty());
        Elements.splitIntoElementsAndResources(Arrays.asList(this.root, null), elements, null, null, null);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        elements.clear();
        Elements.splitIntoElementsAndResources(Arrays.asList(new Object[]{"abc", this.root}), elements, null, null, null);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        elements.clear();
        SimpleModelManager manager2 = new SimpleModelManager();
        manager2.model = new SimpleModel();
        SimpleElement root2 = new SimpleElement(null, "root", manager2);
        Elements.splitIntoElementsAndResources(Arrays.asList(this.root, root2), elements, null, null, null);
        ElementsTest.assertEquals(Arrays.asList(this.root, root2), elements);
        elements.clear();
        Elements.splitIntoElementsAndResources(Arrays.asList(this.root, root2), elements, (IModel)this.manager.getModel(), null, null);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        elements.clear();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("p");
        final IFile file = project.getFile("abc");
        Elements.splitIntoElementsAndResources(Arrays.asList(new IAdaptable[]{this.root, project, file}), elements, null, null, null);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        elements.clear();
        ArrayList resources = new ArrayList();
        Elements.splitIntoElementsAndResources(Arrays.asList(new IAdaptable[]{this.root, project, file}), elements, null, resources, null);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        ElementsTest.assertEquals(Arrays.asList(project, file), resources);
        elements.clear();
        resources.clear();
        final SimpleSourceFile abc = new SimpleSourceFile((IElement)this.root, "abc", null, manager2){

            public boolean exists_() {
                return true;
            }
        };
        IElementHandleFactory elementHandleFactory = new IElementHandleFactory(){

            public IElement createFromResourceHandle(IResource resource) {
                if (file.equals((Object)resource)) {
                    return abc;
                }
                return null;
            }

            public IElement createFromHandleMemento(String memento) {
                return null;
            }
        };
        Elements.splitIntoElementsAndResources(Arrays.asList(new IAdaptable[]{this.root, project, file}), elements, null, resources, (IElementHandleFactory)elementHandleFactory);
        ElementsTest.assertEquals(Arrays.asList(new Element[]{this.root, abc}), elements);
        ElementsTest.assertEquals(Collections.singletonList(project), resources);
        elements.clear();
        resources.clear();
        Elements.splitIntoElementsAndResources(Arrays.asList(new IAdaptable[]{this.root, project, file}), elements, (IModel)this.manager.getModel(), resources, (IElementHandleFactory)elementHandleFactory);
        ElementsTest.assertEquals(Collections.singletonList(this.root), elements);
        ElementsTest.assertEquals(Arrays.asList(project, file), resources);
        elements.clear();
        resources.clear();
    }
}

