/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.impl.DefaultWorkingCopyCallback;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.handly.model.impl.IWorkingCopyInfo;
import org.eclipse.handly.model.impl.support.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.model.impl.support.WorkingCopyInfo;
import org.eclipse.handly.util.Property;

public class WorkingCopyTest
extends TestCase {
    private SimpleSourceFile sourceFile = new SimpleSourceFile(null, null, null, new SimpleModelManager());

    public void testBug479623() throws Exception {
        final boolean[] stop = new boolean[1];
        final boolean[] failure = new boolean[1];
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stop[0]) {
                    if (!WorkingCopyTest.this.sourceFile.acquireExistingWorkingCopy_(null)) continue;
                    try {
                        WorkingCopyInfo info = WorkingCopyTest.this.sourceFile.getElementManager_().peekAtWorkingCopyInfo((ISourceFileImplSupport)WorkingCopyTest.this.sourceFile);
                        if (info.isInitialized()) continue;
                        failure[0] = true;
                        return;
                    }
                    finally {
                        WorkingCopyTest.this.sourceFile.releaseWorkingCopy_();
                    }
                }
            }
        });
        thread.start();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Buffer buffer = new Buffer();){
                this.sourceFile.becomeWorkingCopy_(Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)buffer), null);
                this.sourceFile.releaseWorkingCopy_();
                WorkingCopyTest.assertFalse((boolean)failure[0]);
                WorkingCopyTest.assertTrue((boolean)thread.isAlive());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            stop[0] = true;
            thread.join();
        }
    }

    public void testCallbackLifecycle() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Buffer buffer = new Buffer();){
            class TestCallback
            extends DefaultWorkingCopyCallback {
                boolean onInit;
                boolean onDispose;

                TestCallback() {
                }

                public void onInit(IWorkingCopyInfo info) throws CoreException {
                    super.onInit(info);
                    this.onInit = true;
                }

                public void onDispose() {
                    this.onDispose = true;
                    super.onDispose();
                }
            }
            TestCallback callback1 = new TestCallback();
            WorkingCopyTest.assertTrue((boolean)this.sourceFile.becomeWorkingCopy_(Contexts.with((IContext[])new IContext[]{Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)buffer), Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_CALLBACK, (Object)((Object)callback1))}), null));
            WorkingCopyTest.assertTrue((boolean)callback1.onInit);
            WorkingCopyTest.assertFalse((boolean)callback1.onDispose);
            TestCallback callback2 = new TestCallback();
            WorkingCopyTest.assertFalse((boolean)this.sourceFile.becomeWorkingCopy_(Contexts.with((IContext[])new IContext[]{Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)buffer), Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_CALLBACK, (Object)((Object)callback2))}), null));
            WorkingCopyTest.assertFalse((boolean)this.sourceFile.releaseWorkingCopy_());
            WorkingCopyTest.assertFalse((boolean)callback2.onInit);
            WorkingCopyTest.assertFalse((boolean)callback2.onDispose);
            WorkingCopyTest.assertFalse((boolean)callback1.onDispose);
            WorkingCopyTest.assertTrue((boolean)this.sourceFile.releaseWorkingCopy_());
            WorkingCopyTest.assertTrue((boolean)callback1.onDispose);
            class ThrowingCallback
            extends TestCallback {
                ThrowingCallback() {
                }

                @Override
                public void onInit(IWorkingCopyInfo info) throws CoreException {
                    super.onInit(info);
                    throw new CoreException(Status.CANCEL_STATUS);
                }
            }
            ThrowingCallback callback3 = new ThrowingCallback();
            try {
                this.sourceFile.becomeWorkingCopy_(Contexts.with((IContext[])new IContext[]{Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)buffer), Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_CALLBACK, (Object)((Object)callback3))}), null);
                WorkingCopyTest.fail();
            }
            catch (CoreException e) {
                WorkingCopyTest.assertSame((Object)e.getStatus(), (Object)Status.CANCEL_STATUS);
            }
            WorkingCopyTest.assertTrue((boolean)callback3.onInit);
            WorkingCopyTest.assertTrue((boolean)callback3.onDispose);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

