/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import junit.framework.TestCase;
import org.eclipse.handly.util.LruCache;
import org.eclipse.handly.util.OverflowingLruCache;

public class OverflowingCacheTest
extends TestCase {
    public void testCacheFill() {
        int spaceLimit = 500;
        ElementCache cache = new ElementCache(500);
        Element[] elements = new Element[500];
        int i = 0;
        while (i < 500) {
            elements[i] = new Element(i, false);
            cache.put(elements[i], i);
            ++i;
        }
        OverflowingCacheTest.assertEquals((String)"space limit incorrect", (int)500, (int)cache.getSpaceLimit());
        OverflowingCacheTest.assertEquals((String)"current space incorrect", (int)500, (int)cache.getCurrentSpace());
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect", (int)0, (int)cache.getOverflow());
        i = 499;
        while (i >= 0) {
            Integer value = (Integer)cache.get(elements[i]);
            OverflowingCacheTest.assertEquals((String)"wrong value", (Object)i, (Object)value);
            --i;
        }
    }

    public void testCacheUseNoOverflow() {
        Integer value;
        int spaceLimit = 500;
        int entryCount = 1000;
        int expectedCurrent = 334;
        ElementCache cache = new ElementCache(500);
        Element[] elements = new Element[1000];
        int i = 0;
        while (i < 1000) {
            elements[i] = new Element(i, false);
            cache.put(elements[i], i);
            ++i;
        }
        OverflowingCacheTest.assertEquals((String)"space limit incorrect", (int)500, (int)cache.getSpaceLimit());
        OverflowingCacheTest.assertEquals((String)"current space incorrect", (int)334, (int)cache.getCurrentSpace());
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect", (int)0, (int)cache.getOverflow());
        i = 999;
        while (i >= 666) {
            value = (Integer)cache.get(elements[i]);
            OverflowingCacheTest.assertEquals((String)"wrong value", (Object)i, (Object)value);
            --i;
        }
        i = 0;
        while (i < 666) {
            value = (Integer)cache.get(elements[i]);
            OverflowingCacheTest.assertNull((String)"entry should not be present", (Object)value);
            ++i;
        }
    }

    public void testCacheUseOverflow() {
        int spaceLimit = 500;
        int entryCount = 1000;
        ElementCache cache = new ElementCache(500);
        Element[] elements = new Element[1000];
        int i = 0;
        while (i < 1000) {
            elements[i] = new Element(i, this.hasUnsavedChanges(i));
            cache.put(elements[i], i);
            ++i;
        }
        OverflowingCacheTest.assertEquals((String)"current space incorrect", (int)900, (int)cache.getCurrentSpace());
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect", (int)400, (int)cache.getOverflow());
        i = 999;
        while (i >= 0) {
            Integer value = (Integer)cache.get(elements[i]);
            if (this.hasUnsavedChanges(i)) {
                OverflowingCacheTest.assertEquals((String)"wrong value", (Object)i, (Object)value);
            } else {
                OverflowingCacheTest.assertNull((String)"entry should not be present", (Object)value);
            }
            --i;
        }
        i = 0;
        while (i < 1000) {
            elements[i].save();
            ++i;
        }
        cache.put(new Element(1001, false), 1001);
        OverflowingCacheTest.assertEquals((String)"current space incorrect (after flush)", (int)168, (int)cache.getCurrentSpace());
        OverflowingCacheTest.assertEquals((String)"overflow space incorrect (after flush)", (int)0, (int)cache.getOverflow());
    }

    private boolean hasUnsavedChanges(int i) {
        return i % 10 != 0;
    }

    private static class Element {
        private final int index;
        private boolean hasUnsavedChanges;

        public Element(int index, boolean hasUnsavedChanges) {
            this.index = index;
            this.hasUnsavedChanges = hasUnsavedChanges;
        }

        public void save() {
            this.hasUnsavedChanges = false;
        }

        public boolean close() {
            return !this.hasUnsavedChanges;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('#');
            sb.append(this.index);
            if (this.hasUnsavedChanges) {
                sb.append('*');
            }
            return sb.toString();
        }
    }

    private static class ElementCache
    extends OverflowingLruCache<Element, Integer> {
        public ElementCache(int spaceLimit) {
            this(spaceLimit, 0);
        }

        protected ElementCache(int spaceLimit, int overflow) {
            super(spaceLimit, overflow);
        }

        protected boolean close(LruCache.LruCacheEntry<Element, Integer> entry) {
            return ((Element)entry.key).close();
        }

        protected OverflowingLruCache<Element, Integer> newInstance(int spaceLimit, int overflow) {
            return new ElementCache(spaceLimit, overflow);
        }
    }
}

