/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.outline.CollapseAllActionContribution;
import org.eclipse.handly.ui.outline.CommonOutlinePage;
import org.eclipse.handly.ui.outline.ElementChangeListenerContribution;
import org.eclipse.handly.ui.outline.LexicalSortActionContribution;
import org.eclipse.handly.ui.outline.LexicalSortContribution;
import org.eclipse.handly.ui.outline.LinkWithEditorActionContribution;
import org.eclipse.handly.ui.outline.LinkWithEditorContribution;
import org.eclipse.handly.ui.outline.SourceElementLinkingHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;

public abstract class HandlyOutlinePage
extends CommonOutlinePage
implements IContentAdapterProvider {
    @Override
    public void init(IEditorPart editor) {
        super.init(editor);
        this.addOutlineContributions();
    }

    public IContentAdapter getContentAdapter() {
        return NullContentAdapter.INSTANCE;
    }

    @Override
    protected Object computeInput() {
        IElement inputElement = this.getInputElementProvider().getElement(this.getEditor().getEditorInput());
        return this.getContentAdapter().getCorrespondingElement(inputElement);
    }

    protected abstract IInputElementProvider getInputElementProvider();

    protected void addOutlineContributions() {
        this.addOutlineContribution(new ElementChangeListenerContribution(){

            @Override
            protected void addElementChangeListener(IElementChangeListener listener) {
                HandlyOutlinePage.this.addElementChangeListener(listener);
            }

            @Override
            protected void removeElementChangeListener(IElementChangeListener listener) {
                HandlyOutlinePage.this.removeElementChangeListener(listener);
            }

            @Override
            protected void elementChanged(IElementChangeEvent event) {
                HandlyOutlinePage.this.elementChanged(event);
            }
        });
        this.addCollapseAllSupport();
        this.addLinkWithEditorSupport();
        this.addSortingSupport();
    }

    protected void addCollapseAllSupport() {
        this.addOutlineContribution(new CollapseAllActionContribution());
    }

    protected void addLinkWithEditorSupport() {
        this.addOutlineContribution(new LinkWithEditorActionContribution());
        this.addOutlineContribution(new LinkWithEditorContribution(){

            @Override
            protected OpenAndLinkWithEditorHelper getLinkingHelper() {
                return new SourceElementLinkingHelper(this.getOutlinePage(), HandlyOutlinePage.this.getInputElementProvider());
            }
        });
    }

    protected void addSortingSupport() {
        this.addOutlineContribution(new LexicalSortActionContribution());
        this.addOutlineContribution(new LexicalSortContribution());
    }

    protected abstract void addElementChangeListener(IElementChangeListener var1);

    protected abstract void removeElementChangeListener(IElementChangeListener var1);

    protected void elementChanged(IElementChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!HandlyOutlinePage.this.getTreeViewer().getControl().isDisposed()) {
                    HandlyOutlinePage.this.refresh();
                }
            }
        });
    }
}

