/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineContribution;
import org.eclipse.handly.ui.preference.IBooleanPreference;
import org.eclipse.handly.ui.preference.IPreferenceListener;
import org.eclipse.handly.ui.preference.PreferenceChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class OutlineSorterContribution
extends OutlineContribution {
    private ViewerComparator comparator;
    private ViewerComparator defaultComparator;
    private ViewerComparator oldComparator;
    private IBooleanPreference preference;
    private IPreferenceListener preferenceListener = new IPreferenceListener(){

        @Override
        public void preferenceChanged(PreferenceChangeEvent event) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (OutlineSorterContribution.this.preference == null) {
                        return;
                    }
                    final TreeViewer treeViewer = OutlineSorterContribution.this.getOutlinePage().getTreeViewer();
                    Control control = treeViewer.getControl();
                    control.setRedraw(false);
                    BusyIndicator.showWhile((Display)control.getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreePath[] treePaths = treeViewer.getExpandedTreePaths();
                            if (OutlineSorterContribution.this.preference.getValue()) {
                                treeViewer.setComparator(OutlineSorterContribution.this.comparator);
                            } else {
                                treeViewer.setComparator(OutlineSorterContribution.this.defaultComparator);
                            }
                            treeViewer.setExpandedTreePaths(treePaths);
                        }
                    });
                    control.setRedraw(true);
                }
            });
        }
    };

    @Override
    public void init(ICommonOutlinePage outlinePage) {
        super.init(outlinePage);
        this.preference = this.getPreference();
        if (this.preference != null) {
            this.comparator = this.getComparator();
            this.defaultComparator = this.getDefaultComparator();
            TreeViewer treeViewer = outlinePage.getTreeViewer();
            this.oldComparator = treeViewer.getComparator();
            if (this.preference.getValue()) {
                treeViewer.setComparator(this.comparator);
            } else {
                treeViewer.setComparator(this.defaultComparator);
            }
            this.preference.addListener(this.preferenceListener);
        }
    }

    @Override
    public void dispose() {
        if (this.preference != null) {
            this.preference.removeListener(this.preferenceListener);
            TreeViewer treeViewer = this.getOutlinePage().getTreeViewer();
            if (!treeViewer.getControl().isDisposed()) {
                treeViewer.setComparator(this.oldComparator);
            }
            this.preference = null;
        }
        super.dispose();
    }

    protected abstract IBooleanPreference getPreference();

    protected abstract ViewerComparator getComparator();

    protected ViewerComparator getDefaultComparator() {
        return null;
    }
}

