/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.handly.context.Context;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.xtext.ui.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.IReconcileStrategy;
import org.eclipse.handly.model.impl.IWorkingCopyInfo;
import org.eclipse.handly.model.impl.WorkingCopyCallback;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;
import org.eclipse.handly.xtext.ui.editor.HandlyXtextDocument;
import org.eclipse.handly.xtext.ui.editor.NoXtextResourceException;
import org.eclipse.xtext.resource.XtextResource;

public class XtextWorkingCopyCallback
extends WorkingCopyCallback {
    private final HandlyXtextDocument.IReconcilingListener reconcilingListener = new HandlyXtextDocument.IReconcilingListener(){

        @Override
        public void reconciled(XtextResource resource, NonExpiringSnapshot snapshot, boolean forced, IProgressMonitor monitor) throws Exception {
            Context context = new Context();
            context.bind(IReconcileStrategy.SOURCE_AST).to((Object)resource);
            context.bind(IReconcileStrategy.SOURCE_CONTENTS).to((Object)snapshot.getContents());
            context.bind(IReconcileStrategy.SOURCE_SNAPSHOT).to((Object)snapshot.getWrappedSnapshot());
            context.bind(IReconcileStrategy.RECONCILING_FORCED).to((Object)forced);
            XtextWorkingCopyCallback.this.getWorkingCopyInfo().getReconcileStrategy().reconcile((IContext)context, monitor);
        }
    };

    public void onInit(IWorkingCopyInfo info) throws CoreException {
        super.onInit(info);
        this.getDocument().addReconcilingListener(this.reconcilingListener);
    }

    public void onDispose() {
        this.getDocument().removeReconcilingListener(this.reconcilingListener);
        super.onDispose();
    }

    public final boolean needsReconciling() {
        return this.getDocument().needsReconciling();
    }

    public final void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        try {
            this.getDocument().reconcile((Boolean)context.getOrDefault(Elements.FORCE_RECONCILING), monitor);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (NoXtextResourceException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    protected final HandlyXtextDocument getDocument() {
        return (HandlyXtextDocument)this.getWorkingCopyInfo().getBuffer().getDocument();
    }
}

