/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.ICoreTextFileBufferProvider;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.TextFileBufferSnapshot;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public final class TextFileBuffer
implements IBuffer {
    private final Object location;
    private ICoreTextFileBufferProvider coreTextFileBufferProvider;
    private int refCount = 1;

    public static TextFileBuffer forLocation(IPath location, LocationKind locationKind) throws CoreException {
        return new TextFileBuffer(ICoreTextFileBufferProvider.forLocation(location, locationKind, ITextFileBufferManager.DEFAULT), null);
    }

    public static TextFileBuffer forFileStore(IFileStore fileStore) throws CoreException {
        return new TextFileBuffer(ICoreTextFileBufferProvider.forFileStore(fileStore, ITextFileBufferManager.DEFAULT), null);
    }

    public static TextFileBuffer forFile(IFile file) throws CoreException {
        return TextFileBuffer.forLocation(file.getFullPath(), LocationKind.IFILE);
    }

    public TextFileBuffer(ICoreTextFileBufferProvider provider, IProgressMonitor monitor) throws CoreException {
        this.coreTextFileBufferProvider = provider;
        if (this.coreTextFileBufferProvider == null) {
            throw new IllegalArgumentException();
        }
        provider.connect(monitor);
        boolean f = false;
        try {
            ITextFileBuffer buffer = provider.getBuffer();
            IPath location = buffer.getLocation();
            if (location == null) {
                location = buffer.getFileStore();
            }
            this.location = location;
            f = true;
        }
        finally {
            if (!f) {
                provider.disconnect(null);
            }
        }
    }

    public ICoreTextFileBufferProvider getCoreTextFileBufferProvider() {
        ICoreTextFileBufferProvider result = this.coreTextFileBufferProvider;
        if (result == null) {
            throw new IllegalStateException("Attempt to access a disconnected TextFileBuffer for " + this.location);
        }
        return result;
    }

    @Override
    public IDocument getDocument() {
        return this.getCoreTextFileBufferProvider().getBuffer().getDocument();
    }

    @Override
    public ISnapshot getSnapshot() {
        ICoreTextFileBufferProvider provider = this.getCoreTextFileBufferProvider();
        return new TextFileBufferSnapshot(provider.getBuffer(), provider.getBufferManager());
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BufferChangeOperation operation = new BufferChangeOperation(this, change);
            if (!this.getCoreTextFileBufferProvider().getBuffer().isSynchronizationContextRequested()) {
                return operation.execute(monitor);
            }
            UiSynchronizer synchronizer = UiSynchronizer.getDefault();
            if (synchronizer == null) {
                throw new IllegalStateException("Synchronization context is requested, but synchronizer is not available");
            }
            UiBufferChangeRunner runner = new UiBufferChangeRunner(synchronizer, operation);
            return runner.run(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    @Override
    public void save(IContext context, IProgressMonitor monitor) throws CoreException {
        this.getCoreTextFileBufferProvider().getBuffer().commit(monitor, false);
    }

    @Override
    public boolean isDirty() {
        return this.getCoreTextFileBufferProvider().getBuffer().isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRef() {
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        ICoreTextFileBufferProvider provider;
        TextFileBuffer textFileBuffer = this;
        synchronized (textFileBuffer) {
            if (--this.refCount != 0) {
                return;
            }
            if (this.coreTextFileBufferProvider == null) {
                return;
            }
            provider = this.coreTextFileBufferProvider;
            this.coreTextFileBufferProvider = null;
        }
        try {
            provider.disconnect(null);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
    }
}

