/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.IElementDeltaImpl;

public class ElementDeltas {
    public static final IElementDelta[] EMPTY_ARRAY = new IElementDelta[0];

    public static IElement getElement(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getElement_();
    }

    public static boolean isEmpty(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).isEmpty_();
    }

    public static boolean isNullOrEmpty(IElementDelta delta) {
        return delta == null || ElementDeltas.isEmpty(delta);
    }

    public static int getKind(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getKind_();
    }

    public static long getFlags(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getFlags_();
    }

    public static boolean isStructuralChange(IElementDelta delta) {
        if (ElementDeltas.isNullOrEmpty(delta)) {
            return false;
        }
        if (ElementDeltas.getKind(delta) != 3) {
            return true;
        }
        long flags = ElementDeltas.getFlags(delta);
        if ((flags & 2L) != 0L) {
            return true;
        }
        return (flags & 0x21L) == 1L;
    }

    public static IElementDelta findDelta(IElementDelta delta, IElement element) {
        return ((IElementDeltaImpl)delta).findDelta_(element);
    }

    public static IElementDelta[] getAffectedChildren(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getAffectedChildren_();
    }

    public static IElementDelta[] getAddedChildren(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getAddedChildren_();
    }

    public static IElementDelta[] getRemovedChildren(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getRemovedChildren_();
    }

    public static IElementDelta[] getChangedChildren(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getChangedChildren_();
    }

    public static IElement getMovedFromElement(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getMovedFromElement_();
    }

    public static IElement getMovedToElement(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getMovedToElement_();
    }

    public static IMarkerDelta[] getMarkerDeltas(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getMarkerDeltas_();
    }

    public static IResourceDelta[] getResourceDeltas(IElementDelta delta) {
        return ((IElementDeltaImpl)delta).getResourceDeltas_();
    }

    public static String toString(IElementDelta delta, IContext context) {
        return ((IElementDeltaImpl)delta).toString_(context);
    }

    private ElementDeltas() {
    }
}

