/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.lang.reflect.Array;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.impl.support.IElementDeltaBuilder;

public class Body {
    private volatile IElement[] children = Elements.EMPTY_ARRAY;

    public IElement[] getChildren() {
        return this.children;
    }

    public void setChildren(IElement[] children) {
        if (children == null) {
            throw new IllegalArgumentException();
        }
        this.children = children;
    }

    public void addChild(IElement child) {
        if (child == null) {
            throw new IllegalArgumentException();
        }
        IElement[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                return;
            }
            ++i;
        }
        this.children = Body.growAndAddToArray(oldChildren, child);
    }

    public void removeChild(IElement child) {
        IElement[] oldChildren = this.children;
        int i = 0;
        int length = oldChildren.length;
        while (i < length) {
            if (oldChildren[i].equals(child)) {
                this.children = Body.removeAndShrinkArray(oldChildren, i);
                break;
            }
            ++i;
        }
    }

    public void findContentChange(Body oldBody, IElement element, IElementDeltaBuilder builder) {
    }

    private static IElement[] growAndAddToArray(IElement[] array, IElement addition) {
        int length = array.length;
        IElement[] result = (IElement[])Array.newInstance(array.getClass().getComponentType(), length + 1);
        System.arraycopy(array, 0, result, 0, length);
        result[length] = addition;
        return result;
    }

    private static IElement[] removeAndShrinkArray(IElement[] array, int index) {
        int rest;
        int length = array.length;
        IElement[] result = (IElement[])Array.newInstance(array.getClass().getComponentType(), length - 1);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if ((rest = length - index - 1) > 0) {
            System.arraycopy(array, index + 1, result, index, rest);
        }
        return result;
    }
}

