/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.support.Body;
import org.eclipse.handly.model.impl.support.ElementManager;
import org.eclipse.handly.model.impl.support.IModelManager;
import org.eclipse.handly.model.impl.support.Messages;
import org.eclipse.handly.util.IndentPolicy;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.ToStringOptions;

public interface IElementImplSupport
extends IElementImplExtension,
IModelManager.Provider {
    public static final Property<Map<IElement, Object>> NEW_ELEMENTS = new Property<Map<IElement, Object>>(String.valueOf(IElementImplSupport.class.getName()) + ".newElements"){};
    public static final Object NO_BODY = new Object();

    default public int defaultHashCode_() {
        return Objects.hash(this.getName_(), this.getParent_());
    }

    default public boolean defaultEquals_(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IElementImplSupport)) {
            return false;
        }
        IElementImplSupport other = (IElementImplSupport)obj;
        if (!other.canEqual_(this)) {
            return false;
        }
        return Objects.equals(this.getName_(), other.getName_()) && Objects.equals(this.getParent_(), other.getParent_());
    }

    default public boolean canEqual_(Object obj) {
        return this.getClass() == obj.getClass();
    }

    @Override
    default public IModel getModel_() {
        return this.getModelManager_().getModel();
    }

    default public ElementManager getElementManager_() {
        return this.getModelManager_().getElementManager();
    }

    @Override
    default public IElement[] getChildrenFromBody_(Object body) {
        return ((Body)body).getChildren();
    }

    @Override
    default public Object findBody_() {
        return this.getElementManager_().get(this);
    }

    @Override
    default public Object peekAtBody_() {
        return this.getElementManager_().peek(this);
    }

    @Override
    default public boolean exists_() {
        if (this.findBody_() != null) {
            return true;
        }
        IElement parent = this.getParent_();
        if (parent != null && !Elements.exists(parent)) {
            return false;
        }
        try {
            this.validateExistence_(Contexts.EMPTY_CONTEXT);
            return true;
        }
        catch (CoreException e) {
            return false;
        }
    }

    public void validateExistence_(IContext var1) throws CoreException;

    default public CoreException newDoesNotExistException_() {
        return new CoreException(Activator.createErrorStatus(MessageFormat.format(Messages.Element_does_not_exist__0, this.toDisplayString_(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.FULL))), null));
    }

    @Override
    default public Object open_(IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        try {
            Object body;
            this.openParent_(!Boolean.TRUE.equals(context.get(FORCE_OPEN)) ? context : Contexts.with(Contexts.of(FORCE_OPEN, Boolean.valueOf(false)), context), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!this.isOpenable_()) {
                body = this.findBody_();
                if (body == null) {
                    throw this.newDoesNotExistException_();
                }
            } else {
                this.validateExistence_(context);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ElementManager elementManager = this.getElementManager_();
                HashMap<IElement, Object> newElements = new HashMap<IElement, Object>();
                elementManager.pushTemporaryCache(newElements);
                try {
                    this.buildStructure_(Contexts.with(Contexts.of(NEW_ELEMENTS, newElements), context), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    elementManager.popTemporaryCache();
                }
                body = newElements.get(this);
                if (body == null) {
                    throw new AssertionError((Object)MessageFormat.format("No body for {0}. Incorrect {1}#buildStructure_ implementation?", this.toString(), this.getClass().getSimpleName()));
                }
                if (((Boolean)context.getOrDefault(FORCE_OPEN)).booleanValue()) {
                    elementManager.put(this, newElements);
                } else {
                    Object existingBody = elementManager.putIfAbsent(this, newElements);
                    if (existingBody != null) {
                        body = existingBody;
                    }
                }
            }
            Object object = body;
            return object;
        }
        finally {
            monitor.done();
        }
    }

    default public void openParent_(IContext context, IProgressMonitor monitor) throws CoreException {
        IElementImplExtension parent;
        IElement p = this.getParent_();
        if (p instanceof IElementImplExtension && (parent = (IElementImplExtension)p).findBody_() == null) {
            parent.open_(context, monitor);
        }
    }

    default public boolean isOpenable_() {
        return true;
    }

    public void buildStructure_(IContext var1, IProgressMonitor var2) throws CoreException;

    @Override
    default public void close_(IContext context) {
        IElementImplExtension.CloseHint hint = (IElementImplExtension.CloseHint)((Object)context.get(CLOSE_HINT));
        if (hint != IElementImplExtension.CloseHint.PARENT_CLOSING && !this.isOpenable_()) {
            return;
        }
        this.remove_(context);
    }

    default public void remove_(IContext context) {
        this.getElementManager_().remove(this);
    }

    default public void removing_(Object body) {
    }

    @Override
    default public String toString_(IContext context) {
        StringBuilder builder = new StringBuilder();
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        int indentLevel = context.getOrDefault(ToStringOptions.INDENT_LEVEL);
        ToStringOptions.FormatStyle style = context.getOrDefault(ToStringOptions.FORMAT_STYLE);
        if (style == ToStringOptions.FormatStyle.FULL || style == ToStringOptions.FormatStyle.LONG) {
            Object body = this.peekAtBody_();
            indentPolicy.appendIndent(builder, indentLevel);
            this.toStringBody_(builder, body, context);
            if (style == ToStringOptions.FormatStyle.FULL) {
                this.toStringAncestors_(builder, context);
            }
            if (body != null && this.getChildrenFromBody_(body).length > 0) {
                indentPolicy.appendLine(builder);
                this.toStringChildren_(builder, body, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.LONG), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(indentLevel + 1)), context));
            }
        } else {
            indentPolicy.appendIndent(builder, indentLevel);
            this.toStringBody_(builder, NO_BODY, context);
            if (style == ToStringOptions.FormatStyle.MEDIUM) {
                this.toStringAncestors_(builder, context);
            }
        }
        return builder.toString();
    }

    default public void toStringAncestors_(StringBuilder builder, IContext context) {
        IElement parent = this.getParent_();
        if (parent != null && Elements.getParent(parent) != null) {
            builder.append(" [in ");
            builder.append(Elements.toString(parent, Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), Contexts.of(ToStringOptions.INDENT_LEVEL, Integer.valueOf(0)), context)));
            builder.append(']');
        }
    }

    default public void toStringChildren_(StringBuilder builder, Object body, IContext context) {
        if (body == null) {
            return;
        }
        IndentPolicy indentPolicy = context.getOrDefault(ToStringOptions.INDENT_POLICY);
        IElement[] children = this.getChildrenFromBody_(body);
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                indentPolicy.appendLine(builder);
            }
            builder.append(Elements.toString(children[i], context));
            ++i;
        }
    }

    default public void toStringBody_(StringBuilder builder, Object body, IContext context) {
        this.toStringName_(builder, context);
        if (body == null) {
            builder.append(" (not open)");
        }
    }

    default public void toStringName_(StringBuilder builder, IContext context) {
        builder.append(this.getName_());
    }
}

