/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.ISourceElementImpl;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.TextRange;

public interface ISourceElementImplSupport
extends IElementImplSupport,
ISourceElementImpl {
    @Override
    default public ISourceElementInfo getSourceElementInfo_(IContext context, IProgressMonitor monitor) throws CoreException {
        return (ISourceElementInfo)this.getBody_(context, monitor);
    }

    @Override
    default public ISourceElement getSourceElementAt_(int position, IContext context, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        try {
            ISourceElementInfo info = this.getSourceElementInfo_(context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!ISourceElementImplSupport.checkInRange(position, info, context)) {
                return null;
            }
            ISourceElement iSourceElement = this.getSourceElementAt_(position, info, context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return iSourceElement;
        }
        finally {
            monitor.done();
        }
    }

    default public ISourceElement getSourceElementAt_(int position, ISourceElementInfo info, IContext context, IProgressMonitor monitor) throws CoreException {
        ISnapshot snapshot;
        if (context.get(Elements.BASE_SNAPSHOT) == null && (snapshot = info.getSnapshot()) != null) {
            context = Contexts.with(Contexts.of(Elements.BASE_SNAPSHOT, snapshot), context);
        }
        ISourceConstruct[] children = info.getChildren();
        monitor.beginTask("", children.length);
        try {
            ISourceConstruct[] iSourceConstructArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceConstruct child = iSourceConstructArray[n2];
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ISourceElement found = Elements.getSourceElementAt(child, position, context, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (found != null) {
                    ISourceElement iSourceElement = found;
                    return iSourceElement;
                }
                ++n2;
            }
            ISourceElementImplSupport iSourceElementImplSupport = this;
            return iSourceElementImplSupport;
        }
        finally {
            monitor.done();
        }
    }

    public static boolean checkInRange(int position, ISourceElementInfo info, IContext context) {
        ISnapshot snapshot = info.getSnapshot();
        if (snapshot == null) {
            return false;
        }
        ISnapshot base = context.get(Elements.BASE_SNAPSHOT);
        if (base != null && !base.isEqualTo(snapshot)) {
            throw new StaleSnapshotException();
        }
        TextRange textRange = info.getFullRange();
        return textRange != null && textRange.covers(position);
    }
}

