/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotBase;

public final class TextFileSnapshot
extends TextFileSnapshotBase {
    private final IFile file;
    private final boolean fromFs;
    private final long modificationStamp;
    private String charset;

    public TextFileSnapshot(IFile file, Layer layer) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.fromFs = layer.equals((Object)Layer.FILESYSTEM);
        this.modificationStamp = TextFileSnapshot.getFileModificationStamp(file, this.fromFs);
    }

    @Override
    public boolean exists() {
        if (this.fromFs) {
            return this.modificationStamp != 0L;
        }
        return this.modificationStamp != -1L;
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        if (other instanceof TextFileSnapshot) {
            TextFileSnapshot otherSnapshot = (TextFileSnapshot)other;
            if (this.file.equals((Object)otherSnapshot.file) && this.fromFs == otherSnapshot.fromFs && this.modificationStamp == otherSnapshot.modificationStamp) {
                return true;
            }
        }
        if (!this.isSynchronized()) {
            return false;
        }
        return null;
    }

    @Override
    boolean isSynchronized() {
        return this.modificationStamp == TextFileSnapshot.getFileModificationStamp(this.file, this.fromFs) && this.getStatus().isOK();
    }

    @Override
    void cacheCharset() throws CoreException {
        if (this.charset != null) {
            return;
        }
        this.charset = this.file.getCharset(false);
        if (this.charset == null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream contents = this.file.getContents(this.fromFs);){
                    this.charset = TextFileSnapshot.getCharset(contents, this.file.getName());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
            }
        }
        if (this.charset == null) {
            this.charset = this.file.getParent().getDefaultCharset();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    String readContents() throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                InputStream stream = this.file.getContents(this.fromFs);
                try {
                    String string;
                    block16: {
                        InputStreamReader reader = new InputStreamReader(stream, this.charset);
                        try {
                            string = String.valueOf(TextFileSnapshot.getInputStreamAsCharArray(stream, reader));
                            return string;
                        }
                        finally {
                            if (reader == null) break block16;
                            reader.close();
                        }
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    private static long getFileModificationStamp(IFile file, boolean fromFs) {
        IFileStore fileStore;
        if (!fromFs) {
            return file.getModificationStamp();
        }
        URI uri = file.getLocationURI();
        if (uri == null) {
            return 0L;
        }
        try {
            fileStore = EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
            return 0L;
        }
        return fileStore.fetchInfo().getLastModified();
    }

    public static enum Layer {
        WORKSPACE,
        FILESYSTEM;

    }
}

