/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;

abstract class TextFileSnapshotBase
extends Snapshot {
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private Reference<String> contents;
    private volatile IStatus status = Status.OK_STATUS;

    TextFileSnapshotBase() {
    }

    @Override
    public synchronized String getContents() {
        if (!this.exists()) {
            return "";
        }
        String result = null;
        boolean sync = this.isSynchronized();
        if (this.contents != null) {
            if (!sync) {
                this.contents = null;
            } else {
                result = this.contents.get();
            }
        }
        if (result == null && sync) {
            try {
                this.cacheCharset();
                String currentContents = this.readContents();
                if (this.isSynchronized()) {
                    result = currentContents;
                    this.contents = new SoftReference<String>(result);
                }
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
                this.status = e.getStatus();
            }
        }
        return result;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public abstract boolean exists();

    abstract boolean isSynchronized();

    abstract void cacheCharset() throws CoreException;

    abstract String readContents() throws CoreException;

    static String getCharset(InputStream contents, String fileName) throws IOException {
        IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(contents, fileName, new QualifiedName[]{IContentDescription.CHARSET});
        if (description != null) {
            return description.getCharset();
        }
        return null;
    }

    static char[] getInputStreamAsCharArray(InputStream stream, InputStreamReader reader) throws IOException {
        char[] contents = EMPTY_CHAR_ARRAY;
        int contentsLength = 0;
        int amountRead = -1;
        do {
            int amountRequested;
            if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength + amountRequested];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
            if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
            contentsLength += amountRead;
        } while (amountRead != -1);
        int start = 0;
        if (contentsLength > 0 && "UTF-8".equals(reader.getEncoding()) && contents[0] == '\ufeff') {
            --contentsLength;
            start = 1;
        }
        if (contentsLength < contents.length) {
            char[] cArray = contents;
            contents = new char[contentsLength];
            System.arraycopy(cArray, start, contents, 0, contentsLength);
        }
        return contents;
    }
}

