/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.snapshot.TextFileSnapshotBase;

public final class TextFileStoreSnapshot
extends TextFileSnapshotBase {
    private final IFileStore fileStore;
    private final long modificationStamp;
    private String charset;

    public TextFileStoreSnapshot(IFileStore fileStore) {
        if (fileStore == null) {
            throw new IllegalArgumentException();
        }
        this.fileStore = fileStore;
        this.modificationStamp = TextFileStoreSnapshot.getFileStoreModificationStamp(fileStore);
    }

    public TextFileStoreSnapshot(IFileStore fileStore, Charset charset) {
        this(fileStore);
        this.charset = charset.name();
    }

    @Override
    public boolean exists() {
        return this.modificationStamp != 0L;
    }

    @Override
    protected Boolean predictEquality(Snapshot other) {
        if (other instanceof TextFileStoreSnapshot) {
            TextFileStoreSnapshot otherSnapshot = (TextFileStoreSnapshot)other;
            if (this.fileStore.equals(otherSnapshot.fileStore) && this.modificationStamp == otherSnapshot.modificationStamp) {
                return true;
            }
        }
        if (!this.isSynchronized()) {
            return false;
        }
        return null;
    }

    @Override
    boolean isSynchronized() {
        return this.modificationStamp == TextFileStoreSnapshot.getFileStoreModificationStamp(this.fileStore) && this.getStatus().isOK();
    }

    @Override
    void cacheCharset() throws CoreException {
        if (this.charset != null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream contents = this.fileStore.openInputStream(0, null);){
                this.charset = TextFileStoreSnapshot.getCharset(contents, this.fileStore.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        if (this.charset == null) {
            this.charset = ITextFileBufferManager.DEFAULT.getDefaultEncoding();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    String readContents() throws CoreException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                InputStream stream = this.fileStore.openInputStream(0, null);
                try {
                    String string;
                    block16: {
                        InputStreamReader reader = new InputStreamReader(stream, this.charset);
                        try {
                            string = String.valueOf(TextFileStoreSnapshot.getInputStreamAsCharArray(stream, reader));
                            return string;
                        }
                        finally {
                            if (reader == null) break block16;
                            reader.close();
                        }
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    private static long getFileStoreModificationStamp(IFileStore fileStore) {
        return fileStore.fetchInfo().getLastModified();
    }
}

