/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.callhierarchy;

import org.eclipse.handly.ui.callhierarchy.CallHierarchyKind;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchy;
import org.eclipse.handly.ui.callhierarchy.ICallHierarchyNode;

public final class CallHierarchy
implements ICallHierarchy {
    private final CallHierarchyKind kind;
    private final ICallHierarchyNode[] roots;
    private final String label;

    public CallHierarchy(CallHierarchyKind kind, ICallHierarchyNode[] roots, String label) {
        if (kind == null) {
            throw new IllegalArgumentException();
        }
        if (roots == null) {
            throw new IllegalArgumentException();
        }
        ICallHierarchyNode[] iCallHierarchyNodeArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ICallHierarchyNode root = iCallHierarchyNodeArray[n2];
            if (root == null) {
                throw new IllegalArgumentException();
            }
            if (root.getParent() != null) {
                throw new IllegalArgumentException();
            }
            if (root.getKind() != kind) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (label == null) {
            throw new IllegalArgumentException();
        }
        this.kind = kind;
        this.roots = roots;
        this.label = label;
    }

    @Override
    public CallHierarchyKind getKind() {
        return this.kind;
    }

    @Override
    public ICallHierarchyNode[] getRoots() {
        return this.roots;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

